import traceback

def __lldb_init_module(debugger, dict):
    try:
        from lldbbridge import Dumper, SummaryDumper
    except ImportError:
        print('Failed to find Qt lldbbridge, Qt support will not be enabled')
        return

    try:
        from lldb_formatters.lldb_qt import patch_summary_dumper

        dumper = SummaryDumper.initialize()
        patch_summary_dumper(dumper)
        enable_array_elements_reporting(dumper)

        type_category = 'CidrQt'
        debugger.HandleCommand(f'type summary add -x "^Q.*$" -F lldb_formatters.lldb_qt.get_summary -w {type_category}')
        debugger.HandleCommand(f'type synthetic add -x "^Q.*$" -l lldb_formatters.lldb_qt.CidrSyntheticChildrenProvider -w {type_category}')
        debugger.HandleCommand(f'type category enable {type_category}')

        print('Qt support was enabled')
    except Exception as e:
        print('Failed to enable Qt support')
        traceback.print_exc()


def enable_array_elements_reporting(dumper):
    """
    Enables individual array element reporting instead of
    dumping array memory. See enc logic in dumper.putArrayData().
    """

    dumper.type_encoding_cache = {}
