/*
 * Decompiled with CFR 0.152.
 */
package io.github.cvc5;

import io.github.cvc5.CVC5ApiException;
import java.util.HashMap;
import java.util.Map;

public enum SkolemId {
    INTERNAL(0),
    PURIFY(1),
    GROUND_TERM(2),
    ARRAY_DEQ_DIFF(3),
    BV_EMPTY(4),
    DIV_BY_ZERO(5),
    INT_DIV_BY_ZERO(6),
    MOD_BY_ZERO(7),
    TRANSCENDENTAL_PURIFY(8),
    TRANSCENDENTAL_PURIFY_ARG(9),
    TRANSCENDENTAL_SINE_PHASE_SHIFT(10),
    SHARED_SELECTOR(11),
    HO_DEQ_DIFF(12),
    QUANTIFIERS_SKOLEMIZE(13),
    STRINGS_NUM_OCCUR(14),
    STRINGS_OCCUR_INDEX(15),
    STRINGS_NUM_OCCUR_RE(16),
    STRINGS_OCCUR_INDEX_RE(17),
    STRINGS_OCCUR_LEN_RE(18),
    STRINGS_DEQ_DIFF(19),
    STRINGS_REPLACE_ALL_RESULT(20),
    STRINGS_ITOS_RESULT(21),
    STRINGS_STOI_RESULT(22),
    STRINGS_STOI_NON_DIGIT(23),
    RE_FIRST_MATCH_PRE(24),
    RE_FIRST_MATCH(25),
    RE_FIRST_MATCH_POST(26),
    RE_UNFOLD_POS_COMPONENT(27),
    BAGS_CARD_COMBINE(28),
    BAGS_DISTINCT_ELEMENTS_UNION_DISJOINT(29),
    BAGS_FOLD_CARD(30),
    BAGS_FOLD_COMBINE(31),
    BAGS_FOLD_ELEMENTS(32),
    BAGS_FOLD_UNION_DISJOINT(33),
    BAGS_CHOOSE(34),
    BAGS_DISTINCT_ELEMENTS(35),
    BAGS_DISTINCT_ELEMENTS_SIZE(36),
    BAGS_MAP_PREIMAGE_INJECTIVE(37),
    BAGS_MAP_INDEX(38),
    BAGS_MAP_SUM(39),
    BAGS_DEQ_DIFF(40),
    TABLES_GROUP_PART(41),
    TABLES_GROUP_PART_ELEMENT(42),
    RELATIONS_GROUP_PART(43),
    RELATIONS_GROUP_PART_ELEMENT(44),
    SETS_CHOOSE(45),
    SETS_DEQ_DIFF(46),
    SETS_FOLD_CARD(47),
    SETS_FOLD_COMBINE(48),
    SETS_FOLD_ELEMENTS(49),
    SETS_FOLD_UNION(50),
    SETS_MAP_DOWN_ELEMENT(51),
    FP_MIN_ZERO(52),
    FP_MAX_ZERO(53),
    FP_TO_UBV(54),
    FP_TO_SBV(55),
    FP_TO_REAL(56),
    NONE(57);

    private int value;
    private static int minValue;
    private static int maxValue;
    private static Map<Integer, SkolemId> enumMap;

    private SkolemId(int n2) {
        this.value = n2;
    }

    public static SkolemId fromInt(int n) throws CVC5ApiException {
        if (n < minValue || n > maxValue) {
            throw new CVC5ApiException("SkolemId value " + n + " is outside the valid range [" + minValue + "," + maxValue + "]");
        }
        return enumMap.get(n);
    }

    public int getValue() {
        return this.value;
    }

    static {
        minValue = 0;
        maxValue = 0;
        enumMap = new HashMap<Integer, SkolemId>();
        boolean bl = true;
        for (SkolemId skolemId : SkolemId.values()) {
            int n = skolemId.getValue();
            if (bl) {
                minValue = n;
                maxValue = n;
                bl = false;
            }
            minValue = Math.min(minValue, n);
            maxValue = Math.max(maxValue, n);
            enumMap.put(n, skolemId);
        }
    }
}

