/*
 * Decompiled with CFR 0.152.
 */
package io.github.cvc5;

import io.github.cvc5.AbstractPointer;
import io.github.cvc5.CVC5ApiException;
import io.github.cvc5.DatatypeConstructorDecl;
import io.github.cvc5.DatatypeDecl;
import io.github.cvc5.Kind;
import io.github.cvc5.Op;
import io.github.cvc5.Pair;
import io.github.cvc5.RoundingMode;
import io.github.cvc5.SkolemId;
import io.github.cvc5.Sort;
import io.github.cvc5.SortKind;
import io.github.cvc5.Statistics;
import io.github.cvc5.Term;
import io.github.cvc5.Utils;

public class TermManager
extends AbstractPointer {
    private static native long newTermManager();

    @Override
    protected native void deletePointer(long var1);

    @Override
    protected String toString(long l) {
        throw new UnsupportedOperationException("TermManager.toString() is not supported in the cpp api");
    }

    public TermManager() {
        super(TermManager.newTermManager());
    }

    TermManager(long l) {
        super(l);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TermManager termManager = (TermManager)object;
        return this.pointer == termManager.pointer;
    }

    public Statistics getStatistics() {
        long l = this.getStatistics(this.pointer);
        return new Statistics(l);
    }

    private native long getStatistics(long var1);

    public Sort getBooleanSort() {
        long l = this.getBooleanSort(this.pointer);
        return new Sort(l);
    }

    private native long getBooleanSort(long var1);

    public Sort getIntegerSort() {
        long l = this.getIntegerSort(this.pointer);
        return new Sort(l);
    }

    public native long getIntegerSort(long var1);

    public Sort getRealSort() {
        long l = this.getRealSort(this.pointer);
        return new Sort(l);
    }

    private native long getRealSort(long var1);

    public Sort getRegExpSort() {
        long l = this.getRegExpSort(this.pointer);
        return new Sort(l);
    }

    private native long getRegExpSort(long var1);

    public Sort getRoundingModeSort() throws CVC5ApiException {
        long l = this.getRoundingModeSort(this.pointer);
        return new Sort(l);
    }

    private native long getRoundingModeSort(long var1) throws CVC5ApiException;

    public Sort getStringSort() {
        long l = this.getStringSort(this.pointer);
        return new Sort(l);
    }

    private native long getStringSort(long var1);

    public Sort mkArraySort(Sort sort, Sort sort2) {
        long l = this.mkArraySort(this.pointer, sort.getPointer(), sort2.getPointer());
        return new Sort(l);
    }

    private native long mkArraySort(long var1, long var3, long var5);

    public Sort mkBitVectorSort(int n) throws CVC5ApiException {
        Utils.validateUnsigned(n, "size");
        long l = this.mkBitVectorSort(this.pointer, n);
        return new Sort(l);
    }

    private native long mkBitVectorSort(long var1, int var3);

    public Sort mkFiniteFieldSort(String string, int n) throws CVC5ApiException {
        long l = this.mkFiniteFieldSort(this.pointer, string, n);
        return new Sort(l);
    }

    private native long mkFiniteFieldSort(long var1, String var3, int var4);

    public Sort mkFloatingPointSort(int n, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "exp");
        Utils.validateUnsigned(n2, "sig");
        long l = this.mkFloatingPointSort(this.pointer, n, n2);
        return new Sort(l);
    }

    private native long mkFloatingPointSort(long var1, int var3, int var4);

    public Sort mkDatatypeSort(DatatypeDecl datatypeDecl) throws CVC5ApiException {
        long l = this.mkDatatypeSort(this.pointer, datatypeDecl.getPointer());
        return new Sort(l);
    }

    private native long mkDatatypeSort(long var1, long var3) throws CVC5ApiException;

    public Sort[] mkDatatypeSorts(DatatypeDecl[] datatypeDeclArray) throws CVC5ApiException {
        long[] lArray = Utils.getPointers(datatypeDeclArray);
        long[] lArray2 = this.mkDatatypeSorts(this.pointer, lArray);
        Sort[] sortArray = Utils.getSorts(lArray2);
        return sortArray;
    }

    private native long[] mkDatatypeSorts(long var1, long[] var3) throws CVC5ApiException;

    public Sort mkFunctionSort(Sort sort, Sort sort2) {
        return this.mkFunctionSort(new Sort[]{sort}, sort2);
    }

    public Sort mkFunctionSort(Sort[] sortArray, Sort sort) {
        long l = this.mkFunctionSort(this.pointer, Utils.getPointers(sortArray), sort.getPointer());
        return new Sort(l);
    }

    private native long mkFunctionSort(long var1, long[] var3, long var4);

    public Sort mkParamSort(String string) {
        long l = this.mkParamSort(this.pointer, string);
        return new Sort(l);
    }

    private native long mkParamSort(long var1, String var3);

    public Sort mkParamSort() {
        long l = this.mkParamSort(this.pointer);
        return new Sort(l);
    }

    private native long mkParamSort(long var1);

    public Term mkSkolem(SkolemId skolemId, Term[] termArray) {
        long l = this.mkSkolem(this.pointer, skolemId.getValue(), Utils.getPointers(termArray));
        return new Term(l);
    }

    private native long mkSkolem(long var1, int var3, long[] var4);

    public int getNumIndicesForSkolemId(SkolemId skolemId) {
        int n = this.getNumIndicesForSkolemId(this.pointer, skolemId.getValue());
        return n;
    }

    private native int getNumIndicesForSkolemId(long var1, int var3);

    public Sort mkPredicateSort(Sort[] sortArray) {
        long l = this.mkPredicateSort(this.pointer, Utils.getPointers(sortArray));
        return new Sort(l);
    }

    private native long mkPredicateSort(long var1, long[] var3);

    public Sort mkRecordSort(Pair<String, Sort>[] pairArray) {
        long l = this.mkRecordSort(this.pointer, Utils.getPairs(pairArray));
        return new Sort(l);
    }

    private native long mkRecordSort(long var1, Pair<String, Long>[] var3);

    public Sort mkSetSort(Sort sort) {
        long l = this.mkSetSort(this.pointer, sort.getPointer());
        return new Sort(l);
    }

    private native long mkSetSort(long var1, long var3);

    public Sort mkBagSort(Sort sort) {
        long l = this.mkBagSort(this.pointer, sort.getPointer());
        return new Sort(l);
    }

    private native long mkBagSort(long var1, long var3);

    public Sort mkSequenceSort(Sort sort) {
        long l = this.mkSequenceSort(this.pointer, sort.getPointer());
        return new Sort(l);
    }

    private native long mkSequenceSort(long var1, long var3);

    public Sort mkAbstractSort(SortKind sortKind) {
        long l = this.mkAbstractSort(this.pointer, sortKind.getValue());
        return new Sort(l);
    }

    private native long mkAbstractSort(long var1, int var3);

    public Sort mkUninterpretedSort(String string) {
        long l = this.mkUninterpretedSort(this.pointer, string);
        return new Sort(l);
    }

    private native long mkUninterpretedSort(long var1, String var3);

    public Sort mkUninterpretedSort() {
        long l = this.mkUninterpretedSort(this.pointer);
        return new Sort(l);
    }

    private native long mkUninterpretedSort(long var1);

    public Sort mkUnresolvedDatatypeSort(String string, int n) throws CVC5ApiException {
        Utils.validateUnsigned(n, "arity");
        long l = this.mkUnresolvedDatatypeSort(this.pointer, string, n);
        return new Sort(l);
    }

    private native long mkUnresolvedDatatypeSort(long var1, String var3, int var4);

    public Sort mkUnresolvedDatatypeSort(String string) throws CVC5ApiException {
        return this.mkUnresolvedDatatypeSort(string, 0);
    }

    public Sort mkUninterpretedSortConstructorSort(int n, String string) throws CVC5ApiException {
        Utils.validateUnsigned(n, "arity");
        long l = this.mkUninterpretedSortConstructorSort(this.pointer, n, string);
        return new Sort(l);
    }

    private native long mkUninterpretedSortConstructorSort(long var1, int var3, String var4);

    public Sort mkUninterpretedSortConstructorSort(int n) throws CVC5ApiException {
        Utils.validateUnsigned(n, "arity");
        long l = this.mkUninterpretedSortConstructorSort(this.pointer, n);
        return new Sort(l);
    }

    private native long mkUninterpretedSortConstructorSort(long var1, int var3);

    public Sort mkTupleSort(Sort[] sortArray) {
        long[] lArray = Utils.getPointers(sortArray);
        long l = this.mkTupleSort(this.pointer, lArray);
        return new Sort(l);
    }

    private native long mkTupleSort(long var1, long[] var3);

    public Sort mkNullableSort(Sort sort) {
        long l = this.mkNullableSort(this.pointer, sort.getPointer());
        return new Sort(l);
    }

    private native long mkNullableSort(long var1, long var3);

    public Term mkTerm(Kind kind) {
        long l = this.mkTerm(this.pointer, kind.getValue());
        return new Term(l);
    }

    private native long mkTerm(long var1, int var3);

    public Term mkTerm(Kind kind, Term term) {
        long l = this.mkTerm(this.pointer, kind.getValue(), term.getPointer());
        return new Term(l);
    }

    private native long mkTerm(long var1, int var3, long var4);

    public Term mkTerm(Kind kind, Term term, Term term2) {
        long l = this.mkTerm(this.pointer, kind.getValue(), term.getPointer(), term2.getPointer());
        return new Term(l);
    }

    private native long mkTerm(long var1, int var3, long var4, long var6);

    public Term mkTerm(Kind kind, Term term, Term term2, Term term3) {
        long l = this.mkTerm(this.pointer, kind.getValue(), term.getPointer(), term2.getPointer(), term3.getPointer());
        return new Term(l);
    }

    private native long mkTerm(long var1, int var3, long var4, long var6, long var8);

    public Term mkTerm(Kind kind, Term[] termArray) {
        long[] lArray = Utils.getPointers(termArray);
        long l = this.mkTerm(this.pointer, kind.getValue(), lArray);
        return new Term(l);
    }

    private native long mkTerm(long var1, int var3, long[] var4);

    public Term mkTerm(Op op) {
        long l = this.mkTerm(this.pointer, op.getPointer());
        return new Term(l);
    }

    private native long mkTerm(long var1, long var3);

    public Term mkTerm(Op op, Term term) {
        long l = this.mkTerm(this.pointer, op.getPointer(), term.getPointer());
        return new Term(l);
    }

    private native long mkTerm(long var1, long var3, long var5);

    public Term mkTerm(Op op, Term term, Term term2) {
        long l = this.mkTerm(this.pointer, op.getPointer(), term.getPointer(), term2.getPointer());
        return new Term(l);
    }

    private native long mkTerm(long var1, long var3, long var5, long var7);

    public Term mkTerm(Op op, Term term, Term term2, Term term3) {
        long l = this.mkTerm(this.pointer, op.getPointer(), term.getPointer(), term2.getPointer(), term3.getPointer());
        return new Term(l);
    }

    private native long mkTerm(long var1, long var3, long var5, long var7, long var9);

    public Term mkTerm(Op op, Term[] termArray) {
        long[] lArray = Utils.getPointers(termArray);
        long l = this.mkTerm(this.pointer, op.getPointer(), lArray);
        return new Term(l);
    }

    private native long mkTerm(long var1, long var3, long[] var5);

    public Term mkTuple(Term[] termArray) {
        long[] lArray = Utils.getPointers(termArray);
        long l = this.mkTuple(this.pointer, lArray);
        return new Term(l);
    }

    private native long mkTuple(long var1, long[] var3);

    public Term mkNullableSome(Term term) {
        long l = this.mkNullableSome(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long mkNullableSome(long var1, long var3);

    public Term mkNullableVal(Term term) {
        long l = this.mkNullableVal(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long mkNullableVal(long var1, long var3);

    public Term mkNullableIsNull(Term term) {
        long l = this.mkNullableIsNull(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long mkNullableIsNull(long var1, long var3);

    public Term mkNullableIsSome(Term term) {
        long l = this.mkNullableIsSome(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long mkNullableIsSome(long var1, long var3);

    public Term mkNullableNull(Sort sort) {
        long l = this.mkNullableNull(this.pointer, sort.getPointer());
        return new Term(l);
    }

    private native long mkNullableNull(long var1, long var3);

    public Term mkNullableLift(Kind kind, Term[] termArray) {
        long[] lArray = Utils.getPointers(termArray);
        long l = this.mkNullableLift(this.pointer, kind.getValue(), lArray);
        return new Term(l);
    }

    private native long mkNullableLift(long var1, int var3, long[] var4);

    public Op mkOp(Kind kind) {
        long l = this.mkOp(this.pointer, kind.getValue());
        return new Op(l);
    }

    private native long mkOp(long var1, int var3);

    public Op mkOp(Kind kind, String string) {
        long l = this.mkOp(this.pointer, kind.getValue(), string);
        return new Op(l);
    }

    private native long mkOp(long var1, int var3, String var4);

    public Op mkOp(Kind kind, int n) throws CVC5ApiException {
        Utils.validateUnsigned(n, "arg");
        long l = this.mkOp(this.pointer, kind.getValue(), n);
        return new Op(l);
    }

    private native long mkOp(long var1, int var3, int var4);

    public Op mkOp(Kind kind, int n, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "arg1");
        Utils.validateUnsigned(n2, "arg2");
        long l = this.mkOp(this.pointer, kind.getValue(), n, n2);
        return new Op(l);
    }

    private native long mkOp(long var1, int var3, int var4, int var5);

    public Op mkOp(Kind kind, int[] nArray) throws CVC5ApiException {
        Utils.validateUnsigned(nArray, "args");
        long l = this.mkOp(this.pointer, kind.getValue(), nArray);
        return new Op(l);
    }

    private native long mkOp(long var1, int var3, int[] var4);

    public Term mkTrue() {
        long l = this.mkTrue(this.pointer);
        return new Term(l);
    }

    private native long mkTrue(long var1);

    public Term mkFalse() {
        long l = this.mkFalse(this.pointer);
        return new Term(l);
    }

    private native long mkFalse(long var1);

    public Term mkBoolean(boolean bl) {
        long l = this.mkBoolean(this.pointer, bl);
        return new Term(l);
    }

    private native long mkBoolean(long var1, boolean var3);

    public Term mkPi() {
        long l = this.mkPi(this.pointer);
        return new Term(l);
    }

    private native long mkPi(long var1);

    public Term mkInteger(String string) throws CVC5ApiException {
        long l = this.mkInteger(this.pointer, string);
        return new Term(l);
    }

    private native long mkInteger(long var1, String var3) throws CVC5ApiException;

    public Term mkInteger(long l) {
        long l2 = this.mkInteger(this.pointer, l);
        return new Term(l2);
    }

    private native long mkInteger(long var1, long var3);

    public Term mkReal(String string) throws CVC5ApiException {
        long l = this.mkReal(this.pointer, string);
        return new Term(l);
    }

    private native long mkReal(long var1, String var3) throws CVC5ApiException;

    public Term mkReal(long l) {
        long l2 = this.mkRealValue(this.pointer, l);
        return new Term(l2);
    }

    private native long mkRealValue(long var1, long var3);

    public Term mkReal(long l, long l2) {
        long l3 = this.mkReal(this.pointer, l, l2);
        return new Term(l3);
    }

    private native long mkReal(long var1, long var3, long var5);

    public Term mkRegexpNone() {
        long l = this.mkRegexpNone(this.pointer);
        return new Term(l);
    }

    private native long mkRegexpNone(long var1);

    public Term mkRegexpAll() {
        long l = this.mkRegexpAll(this.pointer);
        return new Term(l);
    }

    private native long mkRegexpAll(long var1);

    public Term mkRegexpAllchar() {
        long l = this.mkRegexpAllchar(this.pointer);
        return new Term(l);
    }

    private native long mkRegexpAllchar(long var1);

    public Term mkEmptySet(Sort sort) {
        long l = this.mkEmptySet(this.pointer, sort.getPointer());
        return new Term(l);
    }

    private native long mkEmptySet(long var1, long var3);

    public Term mkEmptyBag(Sort sort) {
        long l = this.mkEmptyBag(this.pointer, sort.getPointer());
        return new Term(l);
    }

    private native long mkEmptyBag(long var1, long var3);

    public Term mkSepEmp() {
        long l = this.mkSepEmp(this.pointer);
        return new Term(l);
    }

    private native long mkSepEmp(long var1);

    public Term mkSepNil(Sort sort) {
        long l = this.mkSepNil(this.pointer, sort.getPointer());
        return new Term(l);
    }

    private native long mkSepNil(long var1, long var3);

    public Term mkString(String string) {
        return this.mkString(string, false);
    }

    public Term mkString(String string, boolean bl) {
        long l = this.mkString(this.pointer, string, bl);
        return new Term(l);
    }

    private native long mkString(long var1, String var3, boolean var4);

    public Term mkString(int[] nArray) throws CVC5ApiException {
        Utils.validateUnsigned(nArray, "s");
        long l = this.mkString(this.pointer, nArray);
        return new Term(l);
    }

    private native long mkString(long var1, int[] var3);

    public Term mkEmptySequence(Sort sort) {
        long l = this.mkEmptySequence(this.pointer, sort.getPointer());
        return new Term(l);
    }

    private native long mkEmptySequence(long var1, long var3);

    public Term mkUniverseSet(Sort sort) {
        long l = this.mkUniverseSet(this.pointer, sort.getPointer());
        return new Term(l);
    }

    private native long mkUniverseSet(long var1, long var3);

    public Term mkBitVector(int n) throws CVC5ApiException {
        return this.mkBitVector(n, 0L);
    }

    public Term mkBitVector(int n, long l) throws CVC5ApiException {
        Utils.validateUnsigned(n, "size");
        Utils.validateUnsigned(l, "val");
        long l2 = this.mkBitVector(this.pointer, n, l);
        return new Term(l2);
    }

    private native long mkBitVector(long var1, int var3, long var4);

    public Term mkBitVector(int n, String string, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "size");
        Utils.validateUnsigned(n2, "base");
        long l = this.mkBitVector(this.pointer, n, string, n2);
        return new Term(l);
    }

    private native long mkBitVector(long var1, int var3, String var4, int var5);

    public Term mkFiniteFieldElem(String string, Sort sort, int n) throws CVC5ApiException {
        long l = this.mkFiniteFieldElem(this.pointer, string, sort.getPointer(), n);
        return new Term(l);
    }

    private native long mkFiniteFieldElem(long var1, String var3, long var4, int var6);

    public Term mkConstArray(Sort sort, Term term) {
        long l = this.mkConstArray(this.pointer, sort.getPointer(), term.getPointer());
        return new Term(l);
    }

    private native long mkConstArray(long var1, long var3, long var5);

    public Term mkFloatingPointPosInf(int n, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "exp");
        Utils.validateUnsigned(n2, "sig");
        long l = this.mkFloatingPointPosInf(this.pointer, n, n2);
        return new Term(l);
    }

    private native long mkFloatingPointPosInf(long var1, int var3, int var4);

    public Term mkFloatingPointNegInf(int n, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "exp");
        Utils.validateUnsigned(n2, "sig");
        long l = this.mkFloatingPointNegInf(this.pointer, n, n2);
        return new Term(l);
    }

    private native long mkFloatingPointNegInf(long var1, int var3, int var4);

    public Term mkFloatingPointNaN(int n, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "exp");
        Utils.validateUnsigned(n2, "sig");
        long l = this.mkFloatingPointNaN(this.pointer, n, n2);
        return new Term(l);
    }

    private native long mkFloatingPointNaN(long var1, int var3, int var4);

    public Term mkFloatingPointPosZero(int n, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "exp");
        Utils.validateUnsigned(n2, "sig");
        long l = this.mkFloatingPointPosZero(this.pointer, n, n2);
        return new Term(l);
    }

    private native long mkFloatingPointPosZero(long var1, int var3, int var4);

    public Term mkFloatingPointNegZero(int n, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "exp");
        Utils.validateUnsigned(n2, "sig");
        long l = this.mkFloatingPointNegZero(this.pointer, n, n2);
        return new Term(l);
    }

    private native long mkFloatingPointNegZero(long var1, int var3, int var4);

    public Term mkRoundingMode(RoundingMode roundingMode) {
        long l = this.mkRoundingMode(this.pointer, roundingMode.getValue());
        return new Term(l);
    }

    private native long mkRoundingMode(long var1, int var3);

    public Term mkFloatingPoint(int n, int n2, Term term) throws CVC5ApiException {
        Utils.validateUnsigned(n, "exp");
        Utils.validateUnsigned(n2, "sig");
        long l = this.mkFloatingPoint(this.pointer, n, n2, term.getPointer());
        return new Term(l);
    }

    private native long mkFloatingPoint(long var1, int var3, int var4, long var5);

    public Term mkFloatingPoint(Term term, Term term2, Term term3) throws CVC5ApiException {
        long l = this.mkFloatingPointX(this.pointer, term.getPointer(), term2.getPointer(), term3.getPointer());
        return new Term(l);
    }

    private native long mkFloatingPointX(long var1, long var3, long var5, long var7);

    public Term mkCardinalityConstraint(Sort sort, int n) throws CVC5ApiException {
        Utils.validateUnsigned(n, "upperBound");
        long l = this.mkCardinalityConstraint(this.pointer, sort.getPointer(), n);
        return new Term(l);
    }

    private native long mkCardinalityConstraint(long var1, long var3, int var5);

    public Term mkConst(Sort sort, String string) {
        long l = this.mkConst(this.pointer, sort.getPointer(), string);
        return new Term(l);
    }

    private native long mkConst(long var1, long var3, String var5);

    public Term mkConst(Sort sort) {
        long l = this.mkConst(this.pointer, sort.getPointer());
        return new Term(l);
    }

    private native long mkConst(long var1, long var3);

    public Term mkVar(Sort sort) {
        return this.mkVar(sort, "");
    }

    public Term mkVar(Sort sort, String string) {
        long l = this.mkVar(this.pointer, sort.getPointer(), string);
        return new Term(l);
    }

    private native long mkVar(long var1, long var3, String var5);

    public DatatypeConstructorDecl mkDatatypeConstructorDecl(String string) {
        long l = this.mkDatatypeConstructorDecl(this.pointer, string);
        return new DatatypeConstructorDecl(l);
    }

    private native long mkDatatypeConstructorDecl(long var1, String var3);

    public DatatypeDecl mkDatatypeDecl(String string) {
        return this.mkDatatypeDecl(string, false);
    }

    public DatatypeDecl mkDatatypeDecl(String string, boolean bl) {
        long l = this.mkDatatypeDecl(this.pointer, string, bl);
        return new DatatypeDecl(l);
    }

    private native long mkDatatypeDecl(long var1, String var3, boolean var4);

    public DatatypeDecl mkDatatypeDecl(String string, Sort[] sortArray) {
        return this.mkDatatypeDecl(string, sortArray, false);
    }

    public DatatypeDecl mkDatatypeDecl(String string, Sort[] sortArray, boolean bl) {
        long[] lArray = Utils.getPointers(sortArray);
        long l = this.mkDatatypeDecl(this.pointer, string, lArray, bl);
        return new DatatypeDecl(l);
    }

    private native long mkDatatypeDecl(long var1, String var3, long[] var4, boolean var5);

    static {
        Utils.loadLibraries();
    }
}

