/*
 * Decompiled with CFR 0.152.
 */
package io.github.cvc5;

import io.github.cvc5.AbstractPointer;
import io.github.cvc5.CVC5ApiException;
import io.github.cvc5.IPointer;
import io.github.cvc5.Pair;
import io.github.cvc5.Proof;
import io.github.cvc5.Sort;
import io.github.cvc5.Term;
import java.math.BigInteger;

public class Utils {
    public static void loadLibraries() {
        if (!Boolean.parseBoolean(System.getProperty("cvc5.skipLibraryLoad"))) {
            System.loadLibrary("cvc5jni");
        }
    }

    public static Sort[] getSorts(long[] lArray) {
        Sort[] sortArray = new Sort[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            sortArray[i] = new Sort(lArray[i]);
        }
        return sortArray;
    }

    public static Term[] getTerms(long[] lArray) {
        Term[] termArray = new Term[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            termArray[i] = new Term(lArray[i]);
        }
        return termArray;
    }

    public static Proof[] getProofs(long[] lArray) {
        Proof[] proofArray = new Proof[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            proofArray[i] = new Proof(lArray[i]);
        }
        return proofArray;
    }

    public static long[] getPointers(IPointer[] iPointerArray) {
        long[] lArray = new long[iPointerArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = iPointerArray[i].getPointer();
        }
        return lArray;
    }

    public static long[][] getPointers(IPointer[][] iPointerArray) {
        long[][] lArrayArray = new long[iPointerArray.length][];
        for (int i = 0; i < lArrayArray.length; ++i) {
            lArrayArray[i] = new long[iPointerArray[i].length];
            for (int j = 0; j < iPointerArray[i].length; ++j) {
                lArrayArray[i][j] = iPointerArray[i][j].getPointer();
            }
        }
        return lArrayArray;
    }

    public static void validateUnsigned(int n, String string) throws CVC5ApiException {
        if (n < 0) {
            throw new CVC5ApiException("Expected " + string + " '" + n + "' to be non negative.");
        }
    }

    public static void validateUnsigned(long l, String string) throws CVC5ApiException {
        if (l < 0L) {
            throw new CVC5ApiException("Expected " + string + " '" + l + "' to be non negative.");
        }
    }

    public static void validateUnsigned(int[] nArray, String string) throws CVC5ApiException {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0) continue;
            throw new CVC5ApiException("Expected " + string + "[" + i + "] '" + nArray[i] + "' to be non negative.");
        }
    }

    public static void validateUnsigned(long[] lArray, String string) throws CVC5ApiException {
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] >= 0L) continue;
            throw new CVC5ApiException("Expected " + string + "[" + i + "] '" + lArray[i] + "' to be non negative.");
        }
    }

    public static <K> Pair<K, Long>[] getPairs(Pair<K, ? extends AbstractPointer>[] pairArray) {
        Pair[] pairArray2 = new Pair[pairArray.length];
        for (int i = 0; i < pairArray2.length; ++i) {
            pairArray2[i] = new Pair(pairArray[i].first, ((AbstractPointer)pairArray[i].second).getPointer());
        }
        return pairArray2;
    }

    public static Pair<BigInteger, BigInteger> getRational(String string) {
        if (string.contains("/")) {
            String[] stringArray = string.split("/");
            return new Pair<BigInteger, BigInteger>(new BigInteger(stringArray[0]), new BigInteger(stringArray[1]));
        }
        return new Pair<BigInteger, BigInteger>(new BigInteger(string), new BigInteger("1"));
    }

    public static String getRational(Pair<BigInteger, BigInteger> pair) {
        return ((BigInteger)pair.first).toString() + "/" + ((BigInteger)pair.second).toString();
    }

    static {
        Utils.loadLibraries();
    }
}

