/*
 * Decompiled with CFR 0.152.
 */
package io.github.cvc5.modes;

import io.github.cvc5.CVC5ApiException;
import java.util.HashMap;
import java.util.Map;

public enum InputLanguage {
    SMT_LIB_2_6(0),
    SYGUS_2_1(1),
    UNKNOWN(2);

    private int value;
    private static int minValue;
    private static int maxValue;
    private static Map<Integer, InputLanguage> enumMap;

    private InputLanguage(int n2) {
        this.value = n2;
    }

    public static InputLanguage fromInt(int n) throws CVC5ApiException {
        if (n < minValue || n > maxValue) {
            throw new CVC5ApiException("InputLanguage value " + n + " is outside the valid range [" + minValue + "," + maxValue + "]");
        }
        return enumMap.get(n);
    }

    public int getValue() {
        return this.value;
    }

    static {
        minValue = 0;
        maxValue = 0;
        enumMap = new HashMap<Integer, InputLanguage>();
        boolean bl = true;
        for (InputLanguage inputLanguage : InputLanguage.values()) {
            int n = inputLanguage.getValue();
            if (bl) {
                minValue = n;
                maxValue = n;
                bl = false;
            }
            minValue = Math.min(minValue, n);
            maxValue = Math.max(maxValue, n);
            enumMap.put(n, inputLanguage);
        }
    }
}

