/*
 * Decompiled with CFR 0.152.
 */
package io.github.cvc5;

import io.github.cvc5.AbstractPointer;
import io.github.cvc5.CVC5ApiException;
import io.github.cvc5.Kind;
import io.github.cvc5.Op;
import io.github.cvc5.Pair;
import io.github.cvc5.RoundingMode;
import io.github.cvc5.SkolemId;
import io.github.cvc5.Sort;
import io.github.cvc5.Triplet;
import io.github.cvc5.Utils;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class Term
extends AbstractPointer
implements Comparable<Term>,
Iterable<Term> {
    public Term() {
        super(Term.getNullTerm());
    }

    private static native long getNullTerm();

    Term(long l) {
        super(l);
    }

    @Override
    protected native void deletePointer(long var1);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Term term = (Term)object;
        if (this.pointer == term.pointer) {
            return true;
        }
        return this.equals(this.pointer, term.getPointer());
    }

    private native boolean equals(long var1, long var3);

    @Override
    public int compareTo(Term term) {
        return this.compareTo(this.pointer, term.getPointer());
    }

    private native int compareTo(long var1, long var3);

    public int getNumChildren() {
        return this.getNumChildren(this.pointer);
    }

    private native int getNumChildren(long var1);

    public Term getChild(int n) throws CVC5ApiException {
        Utils.validateUnsigned(n, "index");
        long l = this.getChild(this.pointer, n);
        return new Term(l);
    }

    private native long getChild(long var1, int var3);

    public long getId() {
        return this.getId(this.pointer);
    }

    private native long getId(long var1);

    public Kind getKind() throws CVC5ApiException {
        int n = this.getKind(this.pointer);
        return Kind.fromInt(n);
    }

    private native int getKind(long var1);

    public Sort getSort() {
        long l = this.getSort(this.pointer);
        return new Sort(l);
    }

    private native long getSort(long var1);

    public Term substitute(Term term, Term term2) {
        long l = this.substitute(this.pointer, term.getPointer(), term2.getPointer());
        return new Term(l);
    }

    private native long substitute(long var1, long var3, long var5);

    public Term substitute(Term[] termArray, Term[] termArray2) {
        long[] lArray = new long[termArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = termArray[i].getPointer();
        }
        long[] lArray2 = new long[termArray2.length];
        for (int i = 0; i < termArray2.length; ++i) {
            lArray2[i] = termArray2[i].getPointer();
        }
        long l = this.substitute(this.pointer, lArray, lArray2);
        return new Term(l);
    }

    private native long substitute(long var1, long[] var3, long[] var4);

    public boolean hasOp() {
        return this.hasOp(this.pointer);
    }

    private native boolean hasOp(long var1);

    public Op getOp() {
        long l = this.getOp(this.pointer);
        return new Op(l);
    }

    private native long getOp(long var1);

    public boolean hasSymbol() {
        return this.hasSymbol(this.pointer);
    }

    private native boolean hasSymbol(long var1);

    public String getSymbol() {
        return this.getSymbol(this.pointer);
    }

    private native String getSymbol(long var1);

    public boolean isNull() {
        return this.isNull(this.pointer);
    }

    private native boolean isNull(long var1);

    public Term notTerm() {
        long l = this.notTerm(this.pointer);
        return new Term(l);
    }

    private native long notTerm(long var1);

    public Term andTerm(Term term) {
        long l = this.andTerm(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long andTerm(long var1, long var3);

    public Term orTerm(Term term) {
        long l = this.orTerm(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long orTerm(long var1, long var3);

    public Term xorTerm(Term term) {
        long l = this.xorTerm(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long xorTerm(long var1, long var3);

    public Term eqTerm(Term term) {
        long l = this.eqTerm(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long eqTerm(long var1, long var3);

    public Term impTerm(Term term) {
        long l = this.impTerm(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long impTerm(long var1, long var3);

    public Term iteTerm(Term term, Term term2) {
        long l = this.iteTerm(this.pointer, term.getPointer(), term2.getPointer());
        return new Term(l);
    }

    private native long iteTerm(long var1, long var3, long var5);

    @Override
    protected native String toString(long var1);

    public int getRealOrIntegerValueSign() {
        return this.getRealOrIntegerValueSign(this.pointer);
    }

    private native int getRealOrIntegerValueSign(long var1);

    public boolean isIntegerValue() {
        return this.isIntegerValue(this.pointer);
    }

    private native boolean isIntegerValue(long var1);

    public BigInteger getIntegerValue() {
        return new BigInteger(this.getIntegerValue(this.pointer));
    }

    private native String getIntegerValue(long var1);

    public boolean isStringValue() {
        return this.isStringValue(this.pointer);
    }

    private native boolean isStringValue(long var1);

    public String getStringValue() {
        return this.getStringValue(this.pointer);
    }

    private native String getStringValue(long var1);

    public boolean isRealValue() {
        return this.isRealValue(this.pointer);
    }

    private native boolean isRealValue(long var1);

    public Pair<BigInteger, BigInteger> getRealValue() {
        String string = this.getRealValue(this.pointer);
        return Utils.getRational(string);
    }

    private native String getRealValue(long var1);

    public boolean isConstArray() {
        return this.isConstArray(this.pointer);
    }

    private native boolean isConstArray(long var1);

    public Term getConstArrayBase() {
        long l = this.getConstArrayBase(this.pointer);
        return new Term(l);
    }

    private native long getConstArrayBase(long var1);

    public boolean isBooleanValue() {
        return this.isBooleanValue(this.pointer);
    }

    private native boolean isBooleanValue(long var1);

    public boolean getBooleanValue() {
        return this.getBooleanValue(this.pointer);
    }

    private native boolean getBooleanValue(long var1);

    public boolean isBitVectorValue() {
        return this.isBitVectorValue(this.pointer);
    }

    private native boolean isBitVectorValue(long var1);

    public String getBitVectorValue() throws CVC5ApiException {
        return this.getBitVectorValue(2);
    }

    public String getBitVectorValue(int n) throws CVC5ApiException {
        Utils.validateUnsigned(n, "base");
        return this.getBitVectorValue(this.pointer, n);
    }

    private native String getBitVectorValue(long var1, int var3);

    public boolean isFiniteFieldValue() {
        return this.isFiniteFieldValue(this.pointer);
    }

    private native boolean isFiniteFieldValue(long var1);

    public String getFiniteFieldValue() throws CVC5ApiException {
        return this.getFiniteFieldValue(this.pointer);
    }

    private native String getFiniteFieldValue(long var1);

    public boolean isUninterpretedSortValue() {
        return this.isUninterpretedSortValue(this.pointer);
    }

    private native boolean isUninterpretedSortValue(long var1);

    public String getUninterpretedSortValue() {
        return this.getUninterpretedSortValue(this.pointer);
    }

    private native String getUninterpretedSortValue(long var1);

    public boolean isRoundingModeValue() {
        return this.isRoundingModeValue(this.pointer);
    }

    private native boolean isRoundingModeValue(long var1);

    public RoundingMode getRoundingModeValue() throws CVC5ApiException {
        int n = this.getRoundingModeValue(this.pointer);
        return RoundingMode.fromInt(n);
    }

    private native int getRoundingModeValue(long var1);

    public boolean isTupleValue() {
        return this.isTupleValue(this.pointer);
    }

    private native boolean isTupleValue(long var1);

    public Term[] getTupleValue() {
        long[] lArray = this.getTupleValue(this.pointer);
        return Utils.getTerms(lArray);
    }

    private native long[] getTupleValue(long var1);

    public boolean isFloatingPointPosZero() {
        return this.isFloatingPointPosZero(this.pointer);
    }

    private native boolean isFloatingPointPosZero(long var1);

    public boolean isFloatingPointNegZero() {
        return this.isFloatingPointNegZero(this.pointer);
    }

    private native boolean isFloatingPointNegZero(long var1);

    public boolean isFloatingPointPosInf() {
        return this.isFloatingPointPosInf(this.pointer);
    }

    private native boolean isFloatingPointPosInf(long var1);

    public boolean isFloatingPointNegInf() {
        return this.isFloatingPointNegInf(this.pointer);
    }

    private native boolean isFloatingPointNegInf(long var1);

    public boolean isFloatingPointNaN() {
        return this.isFloatingPointNaN(this.pointer);
    }

    private native boolean isFloatingPointNaN(long var1);

    public boolean isFloatingPointValue() {
        return this.isFloatingPointValue(this.pointer);
    }

    private native boolean isFloatingPointValue(long var1);

    public Triplet<Long, Long, Term> getFloatingPointValue() {
        Triplet<String, String, Long> triplet = this.getFloatingPointValue(this.pointer);
        Long l = Long.valueOf((String)triplet.first);
        Long l2 = Long.valueOf((String)triplet.second);
        return new Triplet<Long, Long, Term>(l, l2, new Term((Long)triplet.third));
    }

    private native Triplet<String, String, Long> getFloatingPointValue(long var1);

    public boolean isSetValue() {
        return this.isSetValue(this.pointer);
    }

    private native boolean isSetValue(long var1);

    public Set<Term> getSetValue() {
        long[] lArray = this.getSetValue(this.pointer);
        Term[] termArray = Utils.getTerms(lArray);
        return new HashSet<Term>(Arrays.asList(termArray));
    }

    private native long[] getSetValue(long var1);

    public boolean isSequenceValue() {
        return this.isSequenceValue(this.pointer);
    }

    private native boolean isSequenceValue(long var1);

    public Term[] getSequenceValue() {
        long[] lArray = this.getSequenceValue(this.pointer);
        return Utils.getTerms(lArray);
    }

    private native long[] getSequenceValue(long var1);

    public boolean isCardinalityConstraint() {
        return this.isCardinalityConstraint(this.pointer);
    }

    private native boolean isCardinalityConstraint(long var1);

    public Pair<Sort, BigInteger> getCardinalityConstraint() {
        Pair<Long, BigInteger> pair = this.getCardinalityConstraint(this.pointer);
        Sort sort = new Sort((Long)pair.first);
        return new Pair<Sort, BigInteger>(sort, (BigInteger)pair.second);
    }

    private native Pair<Long, BigInteger> getCardinalityConstraint(long var1);

    public boolean isRealAlgebraicNumber() {
        return this.isRealAlgebraicNumber(this.pointer);
    }

    private native boolean isRealAlgebraicNumber(long var1);

    public Term getRealAlgebraicNumberDefiningPolynomial(Term term) {
        long l = this.getRealAlgebraicNumberDefiningPolynomial(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long getRealAlgebraicNumberDefiningPolynomial(long var1, long var3);

    public Term getRealAlgebraicNumberLowerBound() {
        long l = this.getRealAlgebraicNumberLowerBound(this.pointer);
        return new Term(l);
    }

    private native long getRealAlgebraicNumberLowerBound(long var1);

    public Term getRealAlgebraicNumberUpperBound() {
        long l = this.getRealAlgebraicNumberUpperBound(this.pointer);
        return new Term(l);
    }

    private native long getRealAlgebraicNumberUpperBound(long var1);

    public boolean isSkolem() {
        return this.isSkolem(this.pointer);
    }

    private native boolean isSkolem(long var1);

    public SkolemId getSkolemId() throws CVC5ApiException {
        int n = this.getSkolemId(this.pointer);
        return SkolemId.fromInt(n);
    }

    private native int getSkolemId(long var1);

    public Term[] getSkolemIndices() throws CVC5ApiException {
        long[] lArray = this.getSkolemIndices(this.pointer);
        return Utils.getTerms(lArray);
    }

    private native long[] getSkolemIndices(long var1);

    @Override
    public Iterator<Term> iterator() {
        return new ConstIterator();
    }

    public int hashCode() {
        return this.hashCode(this.pointer);
    }

    private native int hashCode(long var1);

    public class ConstIterator
    implements Iterator<Term> {
        private int currentIndex = -1;
        private int size;

        public ConstIterator() {
            this.size = Term.this.getNumChildren();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.size - 1;
        }

        @Override
        public Term next() {
            if (this.currentIndex >= this.size - 1) {
                throw new NoSuchElementException();
            }
            ++this.currentIndex;
            try {
                return Term.this.getChild(this.currentIndex);
            }
            catch (CVC5ApiException cVC5ApiException) {
                cVC5ApiException.printStackTrace();
                throw new RuntimeException(cVC5ApiException.getMessage());
            }
        }
    }
}

