/*
 * Decompiled with CFR 0.152.
 */
package io.github.cvc5;

import io.github.cvc5.AbstractPointer;
import io.github.cvc5.CVC5ApiException;
import io.github.cvc5.IPointer;
import io.github.cvc5.Pair;
import io.github.cvc5.Proof;
import io.github.cvc5.Sort;
import io.github.cvc5.Term;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;

public class Utils {
    public static final String LIBPATH_IN_JAR = "/cvc5-libs";
    private static boolean areLibrariesLoaded = false;

    public static void transferTo(InputStream inputStream, FileOutputStream fileOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
    }

    public static void loadLibraryFromJar(Path path, String string, String string2) throws FileNotFoundException, Exception {
        String string3 = string + "/" + string2;
        InputStream inputStream = Utils.class.getResourceAsStream(string3);
        if (inputStream == null) {
            throw new FileNotFoundException("Library not found: " + string3);
        }
        File file = path.resolve(string2).toFile();
        file.deleteOnExit();
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            Utils.transferTo(inputStream, fileOutputStream);
        }
        try {
            System.load(file.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new Exception("Couldn't load cvc5 native libraries from JAR");
        }
    }

    public static void loadLibraries() {
        if (!areLibrariesLoaded && !Boolean.parseBoolean(System.getProperty("cvc5.skipLibraryLoad"))) {
            try {
                String string = switch (OS.CURRENT.ordinal()) {
                    case 0 -> "cvc5jni.dll";
                    case 1 -> "libcvc5jni.dylib";
                    default -> "libcvc5jni.so";
                };
                Path path = Files.createTempDirectory("cvc5-libs", new FileAttribute[0]);
                path.toFile().deleteOnExit();
                Utils.loadLibraryFromJar(path, LIBPATH_IN_JAR, string);
            }
            catch (Exception exception) {
                try {
                    System.loadLibrary("cvc5jni");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    throw new UnsatisfiedLinkError("Couldn't load cvc5 native libraries");
                }
            }
            areLibrariesLoaded = true;
        }
    }

    public static Sort[] getSorts(long[] lArray) {
        Sort[] sortArray = new Sort[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            sortArray[i] = new Sort(lArray[i]);
        }
        return sortArray;
    }

    public static Term[] getTerms(long[] lArray) {
        Term[] termArray = new Term[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            termArray[i] = new Term(lArray[i]);
        }
        return termArray;
    }

    public static Proof[] getProofs(long[] lArray) {
        Proof[] proofArray = new Proof[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            proofArray[i] = new Proof(lArray[i]);
        }
        return proofArray;
    }

    public static long[] getPointers(IPointer[] iPointerArray) {
        long[] lArray = new long[iPointerArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = iPointerArray[i].getPointer();
        }
        return lArray;
    }

    public static long[][] getPointers(IPointer[][] iPointerArray) {
        long[][] lArrayArray = new long[iPointerArray.length][];
        for (int i = 0; i < lArrayArray.length; ++i) {
            lArrayArray[i] = new long[iPointerArray[i].length];
            for (int j = 0; j < iPointerArray[i].length; ++j) {
                lArrayArray[i][j] = iPointerArray[i][j].getPointer();
            }
        }
        return lArrayArray;
    }

    public static void validateUnsigned(int n, String string) throws CVC5ApiException {
        if (n < 0) {
            throw new CVC5ApiException("Expected " + string + " '" + n + "' to be non negative.");
        }
    }

    public static void validateUnsigned(long l, String string) throws CVC5ApiException {
        if (l < 0L) {
            throw new CVC5ApiException("Expected " + string + " '" + l + "' to be non negative.");
        }
    }

    public static void validateUnsigned(int[] nArray, String string) throws CVC5ApiException {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0) continue;
            throw new CVC5ApiException("Expected " + string + "[" + i + "] '" + nArray[i] + "' to be non negative.");
        }
    }

    public static void validateUnsigned(long[] lArray, String string) throws CVC5ApiException {
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] >= 0L) continue;
            throw new CVC5ApiException("Expected " + string + "[" + i + "] '" + lArray[i] + "' to be non negative.");
        }
    }

    public static <K> Pair<K, Long>[] getPairs(Pair<K, ? extends AbstractPointer>[] pairArray) {
        Pair[] pairArray2 = new Pair[pairArray.length];
        for (int i = 0; i < pairArray2.length; ++i) {
            pairArray2[i] = new Pair(pairArray[i].first, ((AbstractPointer)pairArray[i].second).getPointer());
        }
        return pairArray2;
    }

    public static Pair<BigInteger, BigInteger> getRational(String string) {
        if (string.contains("/")) {
            String[] stringArray = string.split("/");
            return new Pair<BigInteger, BigInteger>(new BigInteger(stringArray[0]), new BigInteger(stringArray[1]));
        }
        return new Pair<BigInteger, BigInteger>(new BigInteger(string), new BigInteger("1"));
    }

    public static String getRational(Pair<BigInteger, BigInteger> pair) {
        return ((BigInteger)pair.first).toString() + "/" + ((BigInteger)pair.second).toString();
    }

    static {
        Utils.loadLibraries();
    }

    public static enum OS {
        WINDOWS,
        MAC,
        LINUX,
        UNKNOWN;

        public static final OS CURRENT;

        private static OS detectOS() {
            String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            if (string.startsWith("windows")) {
                return WINDOWS;
            }
            if (string.startsWith("mac")) {
                return MAC;
            }
            if (string.startsWith("linux")) {
                return LINUX;
            }
            return UNKNOWN;
        }

        static {
            CURRENT = OS.detectOS();
        }
    }
}

