#!/usr/bin/env sh
# Generated via mepo's development script mepo_dev_generateosmtags.sh
# This script just prints a list of the top amenity tags from OSM's taginfo db
# Regenerated at development time / per-release
echo "
[amenity=parking]: A place for parking cars      
[amenity=bench]: A place for people to sit; allows room for several people.      
[amenity=parking_space]: A single parking space on a parking lot      
[amenity=place_of_worship]: A place where religious services are conducted      
[amenity=restaurant]: A restaurant sells full sit-down meals with servers, and may sell alcohol.      
[amenity=school]: A primary or secondary school (pupils typically aged 6 to 18).      
[amenity=waste_basket]: A single small container for depositing garbage that is easily accessible for pedestrians.      
[amenity=fuel]: A retail facility for refueling motor vehicles      
[amenity=cafe]: A generally informal place with sit-down facilities selling beverages and light meals and/or snacks.      
[amenity=bicycle_parking]: A parking space designed for bicycles.      
[amenity=fast_food]: A place concentrating on very fast counter-only service and take-away food.      
[amenity=shelter]: A small structure for protection against bad weather conditions      
[amenity=bank]: A financial establishment where customers can, among other services, deposit money and take loans      
[amenity=toilets]: A publicly accessible toilet      
[amenity=recycling]: A container or centre that accepts waste for recycling.      
[amenity=pharmacy]: A shop where a pharmacist sells medications      
[amenity=post_box]: A box to deposit outgoing postal items.      
[amenity=kindergarten]: A place for looking after preschool children and (typically) giving early education.      
[amenity=drinking_water]: A drinking water source which provides potable water for consumption.      
[amenity=vending_machine]: A vending machine sells food, drinks, tickets or other goods automatically.      
[amenity=bar]: An establishment that sells alcoholic drinks to be consumed on the premises, characterised by a noisy and vibrant atmosphere. They usually do not sell food to be eaten as a meal. The music is usually loud and you often have to stand.      
[amenity=hunting_stand]: An open or enclosed platform used by hunters to place themselves at an elevated height above the terrain.      
[amenity=hospital]: A hospital providing in-patient medical treatment      
[amenity=atm]: A device that provides the clients of a financial institution with access to financial transactions.      
[amenity=post_office]: A place where letters and parcels may be sent or collected.      
[amenity=waste_disposal]: A medium or large disposal bin, typically for bagged up household or industrial waste.      
[amenity=pub]: An establishment that sells alcoholic drinks that can be consumed on the premises, characterised by a traditional appearance and a relaxed atmosphere. Also sells food which also can be eaten on the premises. Customers can usually sit down at a table.      
[amenity=grave_yard]: A place where people (or sometimes animals) are buried, usually close to a place of worship.      
[amenity=clinic]: A clinic is a medical centre, with more staff than a doctor's office, that does not admit inpatients.      
[amenity=doctors]: A doctor's office, a place to get medical attention or a check up from a physician.      
[amenity=fountain]: A fountain with cultural, decorational or historical significance or which serves a recreational purpose.      
[amenity=parking_entrance]: A entrance to an underground or multi storey parking facility      
[amenity=community_centre]: A place mostly used for local events, festivities and group activities.      
[amenity=townhall]: A townhall serves as a community administrative center or meeting place.      
[amenity=police]: A police station is a facility where police officers patrol from and that is a first point of contact for civilians.      
[amenity=social_facility]: A facility that provides social services      
[amenity=fire_station]: A station from which a fire brigade operates.      
[amenity=dentist]: A dentist practice / surgery.      
[amenity=library]: A place to read and/or lend books      
[amenity=car_wash]: A facility used to clean the exterior of motor vehicles      
[amenity=telephone]: A public telephone      
[amenity=charging_station]: A station that supplies energy to electrical vehicles.      
[amenity=marketplace]: A marketplace where goods and services are traded daily or weekly.      
[amenity=bus_station]: A bus station would usually be a terminus where many routes stop / start, and where you can change between routes, etc.      
[amenity=college]: A place for further education, a post-secondary education institution which is not a University      
[amenity=university]: An educational institution designed for instruction, examination, or both, of students in many branches of advanced learning.      
[amenity=bicycle_rental]: A place, often unattended, where you can pick up and drop off rented bikes.      
[amenity=public_building]: public_building      
[amenity=veterinary]: A place that deals with the prevention, diagnosis and treatment of disease in animals.      
[amenity=childcare]: A place where children are looked after which is not an amenity=kindergarten      
[amenity=ice_cream]: A place that sells ice cream and/or frozen yoghurt over the counter.      
[amenity=taxi]: A place where taxis wait for passengers. Often near where many people congregate.      
[amenity=theatre]: A place where live theatrical performances are held.      
[amenity=water_point]: A place where you can get large amounts of drinking water for refilling fresh water holding tanks.      
[amenity=bbq]: A permanently built place for having a BBQ      
[amenity=cinema]: A movie theater, a place showing movies.      
[amenity=ferry_terminal]: A place where people, cars etc. can board and leave a ferry.      
[amenity=motorcycle_parking]: A place which is designated for parking motorcycles.      
[amenity=parcel_locker]: Machine for picking up and sending parcels.      
[amenity=shower]: Public showers, where people can bathe under water sprays      
[amenity=courthouse]: A building which is home to a court of law, which administers justice according to the rule of law.      
[amenity=driving_school]: A school to learn to drive a motor vehicle      
[amenity=grit_bin]: A container that holds sand, salt and gravel to spread on roads for winter safety      
[amenity=car_rental]: A place from which cars can be rented.      
[amenity=arts_centre]: An arts centre. A venue where a variety of arts are performed or conducted      
[amenity=clock]: A publicly visible clock.      
[amenity=nightclub]: A place to dance and drink at night.      
[amenity=public_bookcase]: A street furniture containing books. Take one, leave one.      
[amenity=watering_place]: A place where water is contained and animals such as horses can drink.      
[amenity=events_venue]: A place that provides facilities for events such as banquets, weddings etc.      
[amenity=bureau_de_change]: An office that exchanges foreign currency and travellers cheques      
[amenity=nursing_home]: A home for disabled/elderly persons who need permanent care.      
[amenity=loading_dock]: A loading dock is an entrance to a building used for loading and unloading goods vehicles.      
[amenity=prison]: A prison or jail where people are incarcerated before trial or after conviction      
[amenity=internet_cafe]: A place whose principal role is providing internet services.      
[amenity=letter_box]: Private mailboxes where mailmen or other people deposit letters to specific addresses.      
[amenity=food_court]: A place with sit-down facilities shared by multiple self-service food vendors.      
[amenity=studio]: A studio used for creating radio or television programmes and broadcasting them. It can also be used to mark a music recording studio.      
[amenity=bicycle_repair_station]: A public tool for self-repair of bicycles.      
[amenity=mobile_money_agent]: A place where mobile money can be payed in and out.      
[amenity=biergarten]: An open-air area where beer is served and you are allowed to bring your own food.      
[amenity=payment_terminal]: Self-service payment kiosk/terminal      
[amenity=public_bath]: A location where the public may bathe in common      
[amenity=car_sharing]: Carsharing station, where you get your booked car, often separate areas on parking places.      
[amenity=social_centre]: A centre of fraternities, sororities, professional societies, union halls and other nonprofit organization.      
[amenity=vehicle_inspection]: A place where legally-required vehicle inspection may be performed      
[amenity=monastery]: An active monastery or convent, occupied by a community of monks or nuns living under religious vows      
[amenity=compressed_air]: A device to inflate tires/tyres (e.g. motorcar, bicycle)      
[amenity=waste_dump_site]: A place where trash was illegally dumped.      
[amenity=music_school]: Music school, an educational institution specialized in the study, training, and research of music      
[amenity=lavoir]: A public place where people come to wash their clothes manually      
[amenity=casino]: A gambling venue with at least one table game.      
[amenity=sanitary_dump_station]: Place for depositing human waste from a toilet holding tank.      
[amenity=animal_breeding]: A facility where animals are bred, usually to sell them      
[amenity=money_transfer]: A place that offers money transfers, especially cash to cash      
[amenity=dojo]: A formal training place for any of the Japanese do arts.      
[amenity=animal_shelter]: A shelter for animal recovery      
[amenity=prep_school]: Tutor or test prep centre      
[amenity=language_school]: An educational institution where one studies a foreign language      
[amenity=trolley_bay]: Place where trolleys are \parked\      
[amenity=waste_transfer_station]: A location that accepts, consolidates and transfers waste in bulk, usually from government or commercial collections.      
[amenity=conference_centre]: A conference centre is a large building used to hold a convention      
[amenity=weighbridge]: A large weight scale to weigh vehicles and goods      
[amenity=boat_rental]: A place where you can rent a boat      
[amenity=boat_storage]: A place to store boats out of the water.      
[amenity=feeding_place]: A place where animals are fed like a manger or an automated feeding station.      
[amenity=ticket_validator]: A tag for ticket validators, often found to gain access to an area or service like public transport or parking garages      
[amenity=lounger]: An object for people to lie down.      
[amenity=ranger_station]: An official park visitor facility with police, visitor information, permit services, etc.      
[amenity=game_feeding]: A game feeding place      
[amenity=love_hotel]: A love hotel is a type of short-stay hotel operated primarily for the purpose of allowing guests privacy for sexual activities.      
[amenity=gambling]: A place for gambling, not being a bookmaker, lottery shop, casino, or adult gaming centre.      
[amenity=animal_boarding]: A facility which cares for pets while the owners are away (e.g. on holiday)      
[amenity=health_post]: A village or neighborhood health post, without a physician      
[amenity=training]: Public place where you can get training.      
[amenity=post_depot]: A distribution centre or sorting office for letters and parcels.      
[amenity=smoking_area]: To identify a designated smoking area      
[amenity=research_institute]: A research institute is an establishment endowed for doing research.      
[amenity=brothel]: An establishment specifically dedicated to prostitution.      
[amenity=vacuum_cleaner]: A device used to clean motor vehicles by vacuum.      
[amenity=dressing_room]: A place where people can change their clothes.      
[amenity=crematorium]: A tag for crematorium, where bodies are burned.      
[amenity=photo_booth]: A stand to create instant photos.      
[amenity=funeral_hall]: A place for holding a funeral ceremony, other than a place of worship      
[amenity=kneipp_water_cure]: A foot bath is a shallow pool, often with handrail.      
[amenity=blood_bank]: A center where blood gathered as a result of blood donation is stored and preserved for later use in blood transfusion      
[amenity=reception_desk]: First contact point of and information source for a POI for an outsider      
[amenity=car_pooling]: Car pooling station or spot, where you meet to get in (or where you get dropped off) someone's car or to pick up (or drop off) someone.      
[amenity=driver_training]: A place for driving training on a closed course      
[amenity=mortuary]: A morgue or funeral home, used for the storage of human corpses      
[amenity=coworking_space]: A place where people can go to work (typically requires a fee); not limited to a single employer      
[amenity=office]: DO NOT USE! Please use instead key:office.      
[amenity=dive_centre]: The base location where sports divers usually start scuba diving      
[amenity=table]: A public table      
[amenity=payment_centre]: A non-bank place, where people can pay bills of public and private services and taxes.      
[amenity=karaoke_box]: A venue specifically for people to enjoy singing along with karaoke, usually with private booths.      
[amenity=stables]: Riding stables, equestrian center      
[amenity=shop]: shop      
[amenity=hookah_lounge]: A place where guests can smoke hookah (aka waterpipe, nargile, shisha).      
[amenity=stripclub]: A place that offer striptease and lap dances.      
[amenity=refugee_site]: A human settlement sheltering refugees and/or internally displaced persons      
[amenity=polling_station]: A place where one can cast a ballot.      
[amenity=exhibition_centre]: An exhibition centre. Also see amenity=conference_centre      
[amenity=emergency_service]: A station from which a civil protection agency operates.      
[amenity=vehicle_ramp]: A ramp for vehicle inspection and repairs.      
[amenity=chair]: A chair which remains located in the same place.      
[amenity=animal_training]: A facility used for non-competitive animal training      
[amenity=binoculars]: A pair of binoculars, fixed by a pole on a certain location for tourists to use      
[amenity=dog_toilet]: A dog toilet is a facility designated for dogs to urinate and excrete.      
[amenity=planetarium]: A theatre built for presenting educational and entertaining shows about astronomy and the night sky, or for training in celestial navigation      
[amenity=waste_basket;recycling]: waste_basket;recycling      
[amenity=spa]: spa      
[amenity=refugee_housing]: refugee_housing      
[amenity=water]: Using this tag is discouraged. Unclear meaning. There are different alternatives.      
[amenity=kitchen]: A public kitchen to use by everyone or customers/guests.      
[amenity=nameplate]: nameplate      
[amenity=baking_oven]: Describes public places that can be used for baking bread.      
[amenity=camping]: camping      
[amenity=yes]: yes      
[amenity=canteen]: A canteen which sells full sit-down meals.      
[amenity=social_club]: A working mans' club, with a private members bar,and other facilities      
[amenity=marae]: A communal meeting area used in Polynesian societies      
[amenity=sanatorium]: ???      
[amenity=rescue_station]: Used to refer to the rescue station (no fire brigade) or to administrative building of rescue service.      
[amenity=toy_library]: A place to play with or lend games and toys.      
[amenity=stage]: A raised platform where performers perform.      
[amenity=ski_rental]: ski_rental      
[amenity=customs]: customs      
[amenity=device_charging_station]: A designated place for charging a mobile device.      
[amenity=commercial]: commercial      
[amenity=public_service]: public_service      
[amenity=workshop]: A room or building in which goods are manufactured or repaired      
[amenity=dancing_school]: dancing school/dance studio      
[amenity=music_venue]: An indoor place to hear live music which is not a theatre      
[amenity=whirlpool]: whirlpool      
[amenity=ski_school]: A ski school is an establishment that teaches skiing, typically in a ski resort.      
[amenity=lifeboat_station]: A boat rescue station.      
[amenity=baby_hatch]: A place where mothers can bring their newborn babies and leave them anonymously in a safe place to be found and cared for.      
[amenity=stadium_seating]: stadium_seating      
[amenity=place of worship]: place of worship      
[amenity=community_hall]: community_hall      
[amenity=give_box]: A small facility where people drop off and pick up various types of items in the sense of free sharing and reuse.      
[amenity=security_booth]: security_booth      
[amenity=traffic_park]: An area with scaled-down roads where children can learn the rules of the road.      
[amenity=גן ילדים]: גן ילדים      
[amenity=dormitory]: Dormitory      
[amenity=clothes_dryer]: Permanently fixed facility to hang clothes for drying.      
[amenity=clubhouse]: The location that is almost exclusively used, and normally owned or operated, by a club      
[amenity=building_yard]: building_yard      
[amenity=healthcare]: healthcare      
[amenity=swingerclub]: In a swingerclub adult people meet to have a party and group sex.      
[amenity=retirement_home]: A home for elderly persons.      
[amenity=store]: store      
[amenity=convenience]: convenience      
[amenity=building]: building      
[amenity=mobile_library]: Used to mark a mobile library stop point.      
[amenity=kick-scooter_rental]: place of a kick-scooter rental      
[amenity=archive]: archive      
[amenity=relay_box]: Post box used by carriers for storing mail between deliveries.      
[amenity=trailer_park]: trailer_park      
[amenity=power_supply]: power_supply      
[amenity=register_office]: register_office      
[amenity=locker]: A locker.      
[amenity=fraternity]: fraternity      
[amenity=bts]: bts      
[amenity=sacco]: sacco      
[amenity=student_accommodation]: student_accommodation      
[amenity=house]: house      
[amenity=cook_stove]: cook_stove      
[amenity=bell]: bell      
[amenity=motorcycle_rental]: Marks a place from which motorcycles can be rented.      
[amenity=private_toilet]: private_toilet      
[amenity=storage]: storage      
[amenity=scout_hut]: scout_hut      
[amenity=border_control]: border_control      
[amenity=building:residential]: building:residential      
[amenity=tricycle_station]: tricycle_station      
[amenity=greenhouse]: greenhouse      
[amenity=funeral_home]: funeral_home      
[amenity=court_yard]: court_yard      
[amenity=fixme]: fixme      
[amenity=construction]: construction      
[amenity=luggage_locker]: luggage_locker      
[amenity=lockers]: lockers      
[amenity=first_aid]: first_aid      
[amenity=auditorium]: auditorium      
[amenity=vacant]: vacant      
[amenity=lifeboat]: lifeboat      
[amenity=public_facility]: public_facility      
[amenity=concert_hall]: Hall designed for performances of live (usually classical) music.      
[amenity=market]: market      
[amenity=village_hall]: village_hall      
[amenity=boat_sharing]: Indicates the location of a boat to share.      
[amenity=mobile_money]: mobile_money      
[amenity=festival_grounds]: A place dedicated for festivals - like song and dance festivals      
[amenity=washing_place]: washing_place      
[amenity=warehouse]: warehouse      
[amenity=harbourmaster]: harbourmaster      
[amenity=self_storage]: self_storage      
[amenity=boathouse]: boathouse      
[amenity=mountain_rescue]: mountain_rescue      
[amenity=coast_guard]: A coast guard station, see also emergency=coast_guard      
[amenity=place_of_mourning]: A room or building where families and friends can come, before the funeral, and view the body of the person who has died.      
[amenity=gym]: gym      
[amenity=piano]: A piano that can be used by the public.      
[amenity=Health Post]: Health Post      
[amenity=checkpoint]: checkpoint      
[amenity=club]: club      
[amenity=public]: public      
[amenity=madrasa]: madrasa      
[amenity=tap]: tap      
[amenity=food_sharing]: A shelf/box/fridge where people drop off and pick up food to reduce food waste and in the sense of free sharing.      
[amenity=sports_viewing_centre]: sports_viewing_centre      
[amenity=bus_stop]: bus_stop      
[amenity=financial_advice]: financial_advice      
[amenity=licensed_club]: licensed_club      
[amenity=mailroom]: mailroom      
[amenity=service]: service      
[amenity=conveneince_store]: conveneince_store      
[amenity=industrial]: industrial      
[amenity=disused]: disused      
[amenity=events_centre]: A large, multi-purpose building used to hold events      
[amenity=buildings]: buildings      
[amenity=church]: church      
[amenity=sign]: sign      
[amenity=bank;place_of_worship]: bank;place_of_worship      
[amenity=laboratory]: laboratory      
[amenity=check_in]: check_in      
[amenity=printer]: A single publicly accessible printer      
[amenity=sports_centre]: sports_centre      
[amenity=nursery]: nursery      
[amenity=food]: food      
[amenity=internet_access]: internet_access      
[amenity=barrier]: barrier      
[amenity=canal]: canal      
[amenity=washing_machine]: A washing machine.      
[amenity=hitching_post]: A post or rail for tethering a horse.      
[amenity=hamlet]: hamlet      
[amenity=toilet]: toilet      
[amenity=garages]: garages      
[amenity=health_centre]: health_centre      
[amenity=shared_taxi]: shared_taxi      
[amenity=cemetery]: cemetery      
[amenity=University]: University      
[amenity=garden]: garden      
[amenity=garage]: garage      
[amenity=reception_area]: reception_area      
[amenity=surf_school]: A surf school is an establishment that teaches surfing.      
[amenity=scooter_parking]: scooter_parking      
[amenity=parish_hall]: parish_hall      
[amenity=personal_service]: personal_service      
[amenity=public_office]: public_office      
[amenity=hydrant]: hydrant      
[amenity=care_home]: care_home      
[amenity=flight_school]: flight_school      
[amenity=government]: government      
[amenity=exhibition_hall]: exhibition_hall      
[amenity=seat]: seat      
[amenity=grocery]: grocery      
[amenity=hall]: hall      
[amenity=fodder_rack]: fodder_rack      
[amenity=church_hall]: church_hall      
[amenity=juice_bar]: An juice bar.      
[amenity=factory]: factory      
[amenity=proposed]: DISCOURAGED, use the disused: key prefix instead.      
[amenity=waste_point]: waste_point      
[amenity=nest_box]: nest_box      
[amenity=animal_hitch]: A place where animals can be hitched or tied to.      
[amenity=scrapyard]: scrapyard      
[amenity=sailing_school]: A sailing school where students learn to sail boats      
[amenity=apartments]: apartments      
[amenity=other]: other      
[amenity=tourism]: tourism      
[amenity=mist_spraying_cooler]: A place where people can cool down by standing under nozzles spraying a fine mist of cool water.      
[amenity=crypt]: Crypt is a stone chamber or vault beneath the floor of a burial vault possibly containing sarcophagi, coffins or relics.      
[amenity=vending_machine;waste_basket]: vending_machine;waste_basket      
[amenity=enclosing]: enclosing      
[amenity=osmica]: A covered or open-air area where operator pruduced food and beverage are served.      
[amenity=notice_board]: notice_board      
[amenity=flowerpot]: flowerpot      
[amenity=bus_garage]: bus_garage      
[amenity=laundry]: laundry      
[amenity=charity]: charity      
[amenity=scooter_rental]: A place that rents motor scooters.      
[amenity=outdoor_seating]: outdoor_seating      
[amenity=sport]: sport      
[amenity=deer_feeding]: deer_feeding      
[amenity=small_electric_vehicle_parking]: small_electric_vehicle_parking      
[amenity=dog_training]: dog_training      
[amenity=beer_garden]: beer_garden      
[amenity=health_facility]: health_facility      
[amenity=wifi]: wifi      
[amenity=well]: well      
[amenity=museum]: museum      
[amenity=art_school]: art_school      
[amenity=rv_storage]: rv_storage      
[amenity=waste_basket;vending_machine]: waste_basket;vending_machine      
[amenity=grass_strip]: grass_strip      
[amenity=meeting_point]: meeting_point      
[amenity=dog_parking]: A place to tie a dog to.      
[amenity=waiting_room]: waiting_room      
[amenity=culture_center]: culture_center      
[amenity=water_well]: water_well      
[amenity=restaurant;bar]: restaurant;bar      
[amenity=no]: no      
[amenity=clothing_donation]: clothing_donation      
[amenity=mobilemoney]: mobilemoney      
[amenity=lounge]: lounge      
[amenity=leisure]: leisure      
[amenity=bar;restaurant]: bar;restaurant      
[amenity=parking_exit]: parking_exit      
[amenity=guest_house]: guest_house      
[amenity=bandstand]: bandstand      
[amenity=residential]: residential      
[amenity=elevator]: elevator      
[amenity=retail]: retail      
[amenity=concession_stand]: A concession stand is a stand of which snacks, such as pretzels, hamburgers and hotdogs, are sold.      
[amenity=company]: company      
[amenity=education]: education      
[amenity=school;place_of_worship]: school;place_of_worship      
[amenity=scout_hall]: scout_hall      
[amenity=tutoring]: tutoring      
[amenity=waiting_area]: waiting_area      
[amenity=adult_gaming_centre]: adult_gaming_centre      
[amenity=truck_stop]: truck_stop      
[amenity=chapel]: chapel      
[amenity=temple]: temple      
[amenity=cooking_school]: cooking_school      
[amenity=carpet_washing]: A place to wash carpets at      
[amenity=motel]: motel      
[amenity=restaurant;cafe]: restaurant;cafe      
[amenity=security]: security      
[amenity=billboard]: billboard      
[amenity=water_tap]: water_tap      
[amenity=aquaculture]: aquaculture      
[amenity=tourist_bus_parking]: A place for parking tourist buses      
[amenity=cafeteria]: cafeteria      
[amenity=winery]: winery      
[amenity=greengrocer]: greengrocer      
[amenity=vivarium]: vivarium      
[amenity=ctc]: ctc      
[amenity=lifeguard]: lifeguard      
[amenity=tent_ground]: tent_ground      
[amenity=hostel]: hostel      
[amenity=preschool]: preschool      
[amenity=social_center]: social_center      
[amenity=ground_sign]: ground_sign      
[amenity=waste]: waste      
[amenity=industry]: industry      
[amenity=beauty]: beauty      
[amenity=public_prive]: public_prive      
[amenity=yacht_club]: Deprecated, use club=sailing instead.      
[amenity=playground]: playground      
[amenity=sculpture]: sculpture      
[amenity=research]: research      
[amenity=farm]: farm      
[amenity=bicycle_wash]: bicycle_wash      
[amenity=ticket_booth]: ticket_booth      
[amenity=information]: information      
[amenity=security_control]: security_control      
[amenity=bear_box]: A box to to safely store food away from wild animals      
[amenity=wildlife_feeding]: wildlife_feeding      
[amenity=Company]: Company      
[amenity=showers]: showers      
[amenity=cold_storage]: cold_storage      
[amenity=chiropractor]: chiropractor      
[amenity=ashtray]: ashtray      
[amenity=library_dropoff]: library_dropoff      
[amenity=mounting_block]: mounting_block      
[amenity=publisher]: publisher      
[amenity=hammock]: hammock      
[amenity=advice]: advice      
[amenity=bicycle_library]: A bicycle library is a facility for lending bicycles and cycling accessories to riders for trial or use.      
[amenity=microfinance]: microfinance      
[amenity=entrance]: entrance      
[amenity=bench;waste_basket]: bench;waste_basket      
[amenity=bleachers]: bleachers      
[amenity=tuition]: A supplementary school with a commercial-basis      
[amenity=utc]: utc      
[amenity=community_information_kiosk]: community_information_kiosk      
[amenity=home]: home      
[amenity=barefootpath]: barefootpath      
[amenity=Kitchen]: Kitchen      
[amenity=your_speed]: your_speed      
[amenity=faculty]: faculty      
[amenity=podiatrist]: podiatrist      
[amenity=karaoke]: karaoke      
[amenity=bakery]: bakery      
[amenity=telephone_exchange]: telephone_exchange      
[amenity=snack_cart]: snack_cart      
[amenity=education_centre]: education_centre      
[amenity=telescope]: telescope      
[amenity=storage_rental]: storage_rental      
[amenity=walkingbus_stop]: walkingbus_stop      
[amenity=*]: *      
[amenity=cafe;restaurant]: cafe;restaurant      
[amenity=credit_institution]: credit_institution      
[amenity=weigh_station]: weigh_station      
[amenity=foot_shower]: foot_shower      
[amenity=art_gallery]: art_gallery      
[amenity=microfinance_bank]: microfinance_bank      
[amenity=left_luggage]: left_luggage      
[amenity=coast_radar_station]: A station doing radar surveillance of coastal areas and waterways.      
[amenity=recreation_ground]: recreation_ground      
[amenity=planter]: planter      
[amenity=trade_school]: trade_school      
[amenity=scout_camp]: scout_camp      
[amenity=community_health_center]: community_health_center      
[amenity=chairs]: chairs      
[amenity=banquet_hall]: banquet_hall      
[amenity=avalanche_transceiver]: avalanche_transceiver      
[amenity=potty_area]: potty_area      
[amenity=swimming_pool]: DISCOURAGED, use tag:leisure=swimming_pool instead      
[amenity=audiologist]: audiologist      
[amenity=wayside_shrine]: wayside_shrine      
[amenity=gallery]: gallery      
[amenity=manhole]: manhole      
[amenity=cloakroom]: A room for people to hang their cloaks or other outerwear when they enter a building      
[amenity=rental]: rental      
[amenity=milk_collection]: milk_collection      
[amenity=school;kindergarten]: school;kindergarten      
[amenity=first_aid_school]: first_aid_school      
[amenity=fish_hatchery]: fish_hatchery      
[amenity=drinks]: drinks      
[amenity=veterinary_pharmacy]: A shop where veterinary medications are sold.      
[amenity=teahouse]: teahouse      
[amenity=brewery]: brewery      
[amenity=escooter_rental]: escooter_rental      
[amenity=stool]: A stool which remains located in the same place.      
[amenity=reuse]: reuse      
[amenity=convent]: convent      
[amenity=mall]: mall      
[amenity=disused_pub]: disused_pub      
[amenity=changing_room]: changing_room      
[amenity=funeral_directors]: funeral_directors      
[amenity=horse_parking]: horse_parking      
[amenity=lost_property_office]: A place where lost articles can be retrieved if found by someone.      
[amenity=dispensary]: dispensary      
[amenity=low-income housing]: low-income housing      
[amenity=residential_home]: residential_home      
[amenity=academy]: academy      
[amenity=manhole_drain]: manhole_drain      
[amenity=scuba_diving]: scuba_diving      
[amenity=jeepney_station]: jeepney_station      
[amenity=post_locker]: post_locker      
[amenity=litter_bin]: litter_bin      
[amenity=kindergarten;school]: kindergarten;school      
[amenity=Fontanile]: Fontanile      
[amenity=pitch]: pitch      
[amenity=building:flats]: building:flats      
[amenity=beacon]: beacon      
[amenity=sport_school]: A sports education facility      
[amenity=astronomical_observatory]: astronomical_observatory      
[amenity=convention_centre]: A large building used to hold conventions, conferences and similar events      
[amenity=fortune_teller]: fortune_teller      
[amenity=fish_cleaning]: fish_cleaning      
[amenity=communal_cooking_area]: communal_cooking_area      
[amenity=snow_removal_station]: Ramp for removing snow from trucks.      
[amenity=meditation_centre]: Place where people can learn and practice meditation.      
[amenity=disused:restaurant]: disused:restaurant      
[amenity=swings]: swings      
[amenity=chemist]: chemist      
[amenity=health_center]: health_center      
[amenity=dog_waste_basket]: dog_waste_basket      
[amenity=orphanage]: orphanage      
[amenity=resort]: resort      
[amenity=tailor]: tailor      
[amenity=stock_exchange]: stock_exchange      
[amenity=job_centre]: job_centre      
[amenity=motorcycle_taxi]: A place where motorcycle taxis wait for passengers      
[amenity=different]: different      
[amenity=doctor]: doctor      
[amenity=solar_water_heater]: solar_water_heater      
[amenity=stable]: stable      
[amenity=depot]: depot      
[amenity=event_venue]: event_venue      
[amenity=cabins]: cabins      
[amenity=lamp]: lamp      
[amenity=schoolyard]: schoolyard      
[amenity=lodge]: lodge      
[amenity=cro]: cro      
[amenity=pub;restaurant]: pub;restaurant      
[amenity=catering]: catering      
[amenity=bin]: bin      
[amenity=cafe;bar]: cafe;bar      
[amenity=health_facility:type]: health_facility:type      
[amenity=money_lender]: money_lender      
[amenity=bikesharing_station]: bikesharing_station      
[amenity=eletric_kick-scooter_rental]: eletric_kick-scooter_rental      
[amenity=road_maintenance]: road_maintenance      
[amenity=agriculture]: agriculture      
[amenity=courtyard]: courtyard      
[amenity=lsd]: lsd      
[amenity=habitation]: habitation      
[amenity=sun_shelter]: sun_shelter      
[amenity=clothes]: clothes      
[amenity=atm;bank]: atm;bank      
[amenity=washingline]: washingline      
[amenity=bus_depot]: bus_depot      
[amenity=employment_agency]: employment_agency      
[amenity=none]: none      
[amenity=conference_center]: conference_center      
[amenity=dryer]: A laundry dryer.      
[amenity=medical_centre]: medical_centre      
[amenity=estate_agent]: estate_agent      
[amenity=shed]: shed      
[amenity=former_pub]: former_pub      
[amenity=kennels]: kennels      
[amenity=small_electric_vehicle]: small_electric_vehicle      
[amenity=auction_house]: auction_house      
[amenity=book_return]: book_return      
[amenity=security_post]: security_post      
[amenity=trailer_rental]: trailer_rental      
[amenity=science_park]: science_park      
[amenity=telecommunication]: telecommunication      
[amenity=tourism=guest_house]: tourism=guest_house      
[amenity=courier]: courier      
[amenity=lecture_hall]: lecture_hall      
[amenity=bus]: bus      
[amenity=NGO]: NGO      
[amenity=bulletin_board]: bulletin_board      
[amenity=bus_parking]: bus_parking      
[amenity=Government]: Government      
[amenity=pisciculture]: pisciculture      
[amenity=salon]: salon      
[amenity=observatory]: observatory      
[amenity=insurance]: insurance      
[amenity=Mill]: Mill      
[amenity=smoking]: smoking      
[amenity=hadware]: hadware      
[amenity=trolley bay]: trolley bay      
[amenity=electronics]: electronics      
[amenity=civic]: civic      
[amenity=amphitheater]: amphitheater      
[amenity=bar;cafe;pub]: bar;cafe;pub      
[amenity=dog_waste_station]: dog_waste_station      
[amenity=ralentisseur]: ralentisseur      
[amenity=firewood]: firewood      
[amenity=shopping]: shopping      
[amenity=public_hall]: public_hall      
[amenity=pond]: pond      
[amenity=cart_return]: cart_return      
[amenity=amphitheatre]: amphitheatre      
[amenity=tutor]: tutor      
[amenity=cargo]: cargo      
[amenity=lawyer]: lawyer      
[amenity=gas]: gas      
[amenity=waste_basket;bench]: waste_basket;bench      
[amenity=eau_brute]: eau_brute      
[amenity=fish_spa]: Doctor Fish      
[amenity=wlan]: wlan      
[amenity=sheltered_housing]: sheltered_housing      
[amenity=dental]: dental      
[amenity=freeshop]: A facility larger than a amenity=give_box where people drop off and pick up various types of items in the sense of free sharing and reuse. Consists of one or several, dedicated room(s).      
[amenity=pawnbroker]: pawnbroker      
[amenity=animal_keeping]: animal_keeping      
[amenity=advice_service]: advice_service      
[amenity=cram_school]: cram_school      
[amenity=delivery_office]: delivery_office      
[amenity=scale]: scale      
[amenity=recreation]: recreation      
[amenity=shelter_emergency]: shelter_emergency      
[amenity=slaughterhouse]: slaughterhouse      
[amenity=swimming_pool_deck]: swimming_pool_deck      
[amenity=mobility_hub]: mobility_hub      
[amenity=camera_obscura]: camera_obscura      
[amenity=bridge]: bridge      
[amenity=coffee]: coffee      
[amenity=spring_board]: spring_board      
[amenity=welfare]: welfare      
[amenity=swinging_table]: swinging_table      
[amenity=garagem]: garagem      
[amenity=apartment]: apartment      
[amenity=cattery]: cattery      
[amenity=vacuum]: vacuum      
[amenity=association]: association      
[amenity=sports]: sports      
[amenity=po_box]: po_box      
[amenity=thermometer]: thermometer      
[amenity=bathhouse]: bathhouse      
[amenity=microwave]: A microwave.      
[amenity=bird_hide]: bird_hide      
[amenity=phone]: phone      
[amenity=rescue_service]: rescue_service      
[amenity=alcohol]: alcohol      
[amenity=air_filling]: air_filling      
[amenity=port]: port      
[amenity=institute]: institute      
[amenity=kick_scooter_parking]: kick_scooter_parking      
[amenity=health]: health      
[amenity=stadium]: stadium      
[amenity=building:commercial]: building:commercial      
[amenity=Temple]: Temple      
[amenity=wifihotspot]: wifihotspot      
[amenity=game_arcade]: game_arcade      
[amenity=truck_rental]: truck_rental      
[amenity=pet_grooming]: pet_grooming      
[amenity=cultural_centre]: cultural_centre      
[amenity=shipping_company]: shipping_company      
[amenity=Lsd]: Lsd      
[amenity=landfill]: landfill      
[amenity=seminary]: seminary      
[amenity=fire_beater]: fire_beater      
[amenity=hardware]: hardware      
[amenity=bank;atm]: bank;atm      
[amenity=departures_board]: departures_board      
[amenity=cyclist_leaning_rail]: cyclist_leaning_rail      
[amenity=survey]: survey      
[amenity=coffeeshop]: coffeeshop      
[amenity=shelter;bench]: shelter;bench      
[amenity=transport]: transport      
[amenity=campground]: campground      
[amenity=station]: station      
[amenity=Informationen]: Informationen      
[amenity=dead_pub]: dead_pub      
[amenity=salt_lick]: salt_lick      
[amenity=camp]: camp      
[amenity=pre_school]: pre_school      
[amenity=rescue]: rescue      
[amenity=radio_station]: radio_station      
[amenity=hitchhiking_bench]: hitchhiking_bench      
[amenity=psychic]: psychic      
[amenity=shelter;bbq]: shelter;bbq      
[amenity=CRO]: CRO      
[amenity=side_strip]: side_strip      
[amenity=mill]: mill      
[amenity=riding_school]: riding_school      
[amenity=computer]: computer      
[amenity=training_center]: training_center      
[amenity=test_center]: test_center      
[amenity=motorcycle_repair]: motorcycle_repair      
[amenity=boot_cleaner]: boot_cleaner      
[amenity=sidewalk]: sidewalk      
[amenity=notary]: notary      
[amenity=goverment_building]: goverment_building      
[amenity=greenhouses]: greenhouses      
[amenity=baggage_claim]: baggage_claim      
[amenity=deli]: deli      
[amenity=equipment_rental]: equipment_rental      
[amenity=health center]: health center      
[amenity=jobcentre]: jobcentre      
[amenity=hut]: hut      
[amenity=kids_area]: kids_area      
[amenity=pyrotechnics]: pyrotechnics      
[amenity=gazebo]: gazebo      
[amenity=fx_station]: fx_station      
[amenity=hairdresser]: hairdresser      
[amenity=fireplace]: fireplace      
[amenity=boutique]: boutique      
[amenity=tool_rental]: tool_rental      
[amenity=vehicle_impound]: vehicle_impound      
[amenity=cosmetics]: cosmetics      
[amenity=walking_bus]: walking_bus      
[amenity=bicycle_parking_space]: bicycle_parking_space      
[amenity=beachhut]: beachhut      
[amenity=surgery]: surgery      
[amenity=bicycle_parking;motorcycle_parking]: bicycle_parking;motorcycle_parking      
[amenity=function_room]: function_room      
[amenity=grandstand]: grandstand      
[amenity=hearing_aids]: hearing_aids      
[amenity=bath]: bath      
[amenity=army]: army      
[amenity=cave]: cave      
[amenity=pet]: pet      
[amenity=rectory]: rectory      
[amenity=vdsl-aru]: vdsl-aru      
[amenity=closed]: closed      
[amenity=cannabis]: cannabis      
[amenity=rest_area]: rest_area      
[amenity=dog_waste]: dog_waste      
[amenity=university;hospital]: university;hospital      
[amenity=barangay hall]: barangay hall      
[amenity=licenced_club]: licenced_club      
[amenity=check-in]: check-in      
[amenity=physiotherapist]: physiotherapist      
[amenity=layby]: layby      
[amenity=open space]: open space      
[amenity=tank]: tank      
[amenity=deposit_sale]: deposit_sale      
[amenity=furniture]: furniture      
[amenity=cuisine]: cuisine      
[amenity=logbook]: logbook      
[amenity=skateboard_parking]: skateboard_parking      
[amenity=nursing_room]: nursing_room      
[amenity=fuel;car_wash]: fuel;car_wash      
[amenity=Office]: Office      
[amenity=loadind_dock]: loadind_dock      
[amenity=fridge]: A fridge appliance, e.g. at a camp site or elsewhere.      
[amenity=public_market]: public_market      
[amenity=tourist]: tourist      
[amenity=baby_care]: baby_care      
[amenity=orthodontist]: orthodontist      
[amenity=dog_wash]: dog_wash      
[amenity=health post]: health post      
[amenity=repair]: repair      
[amenity=dog_grooming]: dog_grooming      
[amenity=building_entrance]: building_entrance      
[amenity=art_studio]: art_studio      
[amenity=border_station]: border_station      
[amenity=bar;cafe]: bar;cafe      
[amenity=retirement_village]: retirement_village      
[amenity=garden_bed]: garden_bed      
[amenity=manger]: manger      
[amenity=convenience_store]: convenience_store      
[amenity=saloon]: saloon      
[amenity=disposal]: disposal      
[amenity=science]: science      
[amenity=stations]: stations      
[amenity=chiropodist]: chiropodist      
[amenity=viewpoint]: viewpoint      
[amenity=Salon]: Salon      
[amenity=cafe;fast_food]: cafe;fast_food      
[amenity=memorial]: memorial      
[amenity=theater]: theater      
[amenity=swimming]: swimming      
[amenity=hide]: hide      
[amenity=hayloft]: hayloft      
[amenity=gate]: gate      
[amenity=wellness]: wellness      
[amenity=internet]: internet      
[amenity=feeding_rack]: feeding_rack      
[amenity=school_vocational]: school_vocational      
[amenity=tricycle_terminal]: tricycle_terminal      
[amenity=fuel;food_court]: fuel;food_court      
[amenity=gymnasium]: gymnasium      
[amenity=nursery_home]: nursery_home      
[amenity=parcel_lockers]: parcel_lockers      
[amenity=food_bank]: food_bank      
[amenity=truck_wash]: truck_wash      
[amenity=water_pump]: water_pump      
[amenity=professional_school]: professional_school      
[amenity=smoking_station]: smoking_station      
[amenity=emergency]: emergency      
[amenity=reception_point]: reception_point      
[amenity=grass]: grass      
[amenity=fonctionnelle]: fonctionnelle      
[amenity=bistro]: bistro      
[amenity=shops]: shops      
[amenity=bungee]: bungee      
[amenity=truck_parking]: truck_parking      
[amenity=mailbox]: mailbox      
[amenity=gas_pump]: gas_pump      
[amenity=military]: military      
[amenity=community]: community      
[amenity=chain]: chain      
[amenity=message_board]: message_board      
[amenity=crucifix]: Rarely used duplicate of tag:man_made=cross and tag:historic=wayside_cross      
[amenity=light_post]: light_post      
[amenity=youth_centre]: youth_centre      
[amenity=Lodge]: Lodge      
[amenity=ischial_support]: ischial_support      
[amenity=waste=trash;cigarettes]: waste=trash;cigarettes      
[amenity=credit_union]: credit_union      
[amenity=restaurant;fast_food]: restaurant;fast_food      
[amenity=carpet_hanger]: carpet_hanger      
[amenity=newsagent]: newsagent      
[amenity=umbrella]: umbrella      
[amenity=blackboard]: blackboard      
[amenity=reception]: reception      
[amenity=statue]: statue      
[cuisine=pizza]: A place that mainly sells pizza.      
[cuisine=burger]: A place that mainly sells burgers      
[cuisine=regional]: A place that serves mainly regional cuisine.      
[cuisine=coffee_shop]: Specifies that a location is most known for its coffee, even if it may serve other types of food.      
[cuisine=italian]: A place that mainly sells Italian food.      
[cuisine=chinese]: A place that mainly sells Chinese food.      
[cuisine=sandwich]: A place that mainly sells sandwiches.      
[cuisine=chicken]: A place that mainly sells chicken      
[cuisine=mexican]: A place that mainly sells Mexican food.      
[cuisine=japanese]: A place that mainly sells Japanese food.      
[cuisine=american]: A place that mainly sells American food.      
[cuisine=kebab]: A place that sells kebabs      
[cuisine=indian]: A place that mainly sells Indian food.      
[cuisine=asian]: A place that mainly sells Asian food.      
[cuisine=sushi]: A place that mainly sells sushi      
[cuisine=french]: A place that mainly sells French food.      
[cuisine=ice_cream]: For places selling ice cream.      
[cuisine=thai]: A place that mainly sells Thai food.      
[cuisine=german]: A place that mainly sells German food.      
[cuisine=greek]: A place that mainly sells Greek food.      
[cuisine=seafood]: For marking place as serving mainly fish, shrimps, lobster...      
[cuisine=korean]: korean      
[cuisine=steak_house]: A place that mainly sells steak. Examples of restaurants include Ruth Chris and Outback.      
[cuisine=fish_and_chips]: An eating place offers primarily fish and chips.      
[cuisine=international]: international      
[cuisine=tex-mex]: tex-mex      
[cuisine=vietnamese]: vietnamese      
[cuisine=noodle]: Japanese, Chinese, Korean noodles such Japanese udon, soba, and ramen; Chinese dandan noodles and tan men; Korean renmyon and bibin myon; and Vietnamese ph? and b�n. Common throughout East Asia and increasingly worldwide.      
[cuisine=turkish]: A place that mainly sells Turkish food.      
[cuisine=barbecue]: Barbecue is a style of cooking normally meats by roasting, smoking or grilling.      
[cuisine=donut;coffee_shop]: donut;coffee_shop      
[cuisine=spanish]: A place that mainly sells Spanish food.      
[cuisine=local]: local      
[cuisine=ramen]: ramen      
[cuisine=fish]: Marking place serving selling fish with exclusion of other seafood      
[cuisine=bubble_tea]: primarily serves tea or milk tea containing tapioca balls or jellies      
[cuisine=donut]: A type of fried dough confectionery or dessert food.      
[cuisine=ice_cream;burger]: ice_cream;burger      
[cuisine=italian;pizza]: italian;pizza      
[cuisine=juice]: juice      
[cuisine=mediterranean]: A place that mainly sells Mediterranean food.      
[cuisine=friture]: Marks a Dutch and Belgian chip shop      
[cuisine=sandwich;bakery]: sandwich;bakery      
[cuisine=breakfast]: breakfast      
[cuisine=crepe]: Indicate that crepe is available in the restaurant or other food establishment.      
[cuisine=pizza;italian]: pizza;italian      
[cuisine=beef_bowl]: beef_bowl      
[cuisine=kebab;pizza]: kebab;pizza      
[cuisine=wings]: A place that mainly sells chicken wings.      
[cuisine=lebanese]: lebanese      
[cuisine=hot_dog]: A place that mainly sells hot dogs.      
[cuisine=tapas]: Spanish tapas      
[cuisine=georgian]: georgian      
[cuisine=breakfast;pancake]: breakfast;pancake      
[cuisine=italian_pizza]: italian_pizza      
[cuisine=indonesian]: indonesian      
[cuisine=cake]: cake      
[cuisine=arab]: arab      
[cuisine=bagel]: bagel      
[cuisine=portuguese]: portuguese      
[cuisine=pasta]: A place that mainly serves pasta. An example of this is spaghetti.      
[cuisine=polish]: polish      
[cuisine=filipino]: filipino      
[cuisine=african]: african      
[cuisine=russian]: russian      
[cuisine=pizza;kebab]: pizza;kebab      
[cuisine=peruvian]: peruvian      
[cuisine=malaysian]: malaysian      
[cuisine=caribbean]: caribbean      
[cuisine=soba]: soba      
[cuisine=frozen_yogurt]: frozen_yogurt      
[cuisine=western;japanese]: western;japanese      
[cuisine=grill]: grill      
[cuisine=noodle;ramen]: noodle;ramen      
[cuisine=bavarian]: bavarian      
[cuisine=brazilian]: A place that mainly sells Brazilian food.      
[cuisine=japanese;sushi]: japanese;sushi      
[cuisine=salad]: salad      
[cuisine=curry]: curry      
[cuisine=pizza;regional]: pizza;regional      
[cuisine=dessert]: This is for establishments specializing in desserts.      
[cuisine=chicken;portuguese]: chicken;portuguese      
[cuisine=heuriger]: heuriger      
[cuisine=steak]: steak      
[cuisine=persian]: persian      
[cuisine=diner]: diner      
[cuisine=british]: british      
[cuisine=buschenschank]: buschenschank      
[cuisine=american;steak]: american;steak      
[cuisine=pizza;burger]: pizza;burger      
[cuisine=italian;regional]: italian;regional      
[cuisine=regional;pizza]: regional;pizza      
[cuisine=coffee]: coffee      
[cuisine=middle_eastern]: middle_eastern      
[cuisine=coffee_shop;sandwich]: coffee_shop;sandwich      
[cuisine=argentinian]: argentinian      
[cuisine=tea]: tea      
[cuisine=dumpling]: dumpling      
[cuisine=balkan]: balkan      
[cuisine=oriental]: oriental      
[cuisine=burger;sandwich]: burger;sandwich      
[cuisine=sausage]: sausage      
[cuisine=german;regional]: german;regional      
[cuisine=taiwanese]: taiwanese      
[cuisine=regional;italian]: regional;italian      
[cuisine=pancake]: Deprecated, use cuisine=crepe instead.      
[cuisine=hotpot]: hotpot      
[cuisine=fast_food]: fast_food      
[cuisine=bistro]: bistro      
[cuisine=pretzel]: pretzel      
[cuisine=burger;pizza]: burger;pizza      
[cuisine=moroccan]: moroccan      
[cuisine=burger;chicken]: burger;chicken      
[cuisine=fine_dining]: fine_dining      
[cuisine=pizza;pasta]: pizza;pasta      
[cuisine=pita]: pita      
[cuisine=ice_cream;bubble_tea]: ice_cream;bubble_tea      
[cuisine=hawaiian]: hawaiian      
[cuisine=noodles]: noodles      
[cuisine=ethiopian]: ethiopian      
[cuisine=latin_american]: latin_american      
[cuisine=bbq]: bbq      
[cuisine=cafe]: cafe      
[cuisine=cake;coffee_shop]: cake;coffee_shop      
[cuisine=fried_chicken]: fried_chicken      
[cuisine=american;breakfast]: american;breakfast      
[cuisine=kebab;turkish]: kebab;turkish      
[cuisine=sushi;japanese]: sushi;japanese      
[cuisine=tacos]: tacos      
[cuisine=shawarma]: shawarma      
[cuisine=donut;coffee]: donut;coffee      
[cuisine=fried_food]: fried_food      
[cuisine=regional;french]: regional;french      
[cuisine=beef_noodle]: beef_noodle      
[cuisine=burger;american]: burger;american      
[cuisine=irish]: irish      
[cuisine=american;buffet]: american;buffet      
[cuisine=american;burger]: american;burger      
[cuisine=austrian]: austrian      
[cuisine=pizza;sandwich]: pizza;sandwich      
[cuisine=italian_pizza;italian]: italian_pizza;italian      
[cuisine=udon]: udon      
[cuisine=regional;german]: regional;german      
[cuisine=meat]: meat      
[cuisine=coffee_shop;ice_cream]: coffee_shop;ice_cream      
[cuisine=italian;italian_pizza]: italian;italian_pizza      
[cuisine=croatian]: croatian      
[cuisine=dumplings]: A kind of traditional Chinese food      
[cuisine=western]: western      
[cuisine=chinese;gyoza]: chinese;gyoza      
[cuisine=fries]: fries      
[cuisine=european]: european      
[cuisine=regional;coffee_shop]: regional;coffee_shop      
[cuisine=danish]: danish      
[cuisine=bolivian]: bolivian      
[cuisine=bakery]: bakery      
[cuisine=tea;coffee_shop]: tea;coffee_shop      
[cuisine=american;chicken]: american;chicken      
[cuisine=potato]: potato      
[cuisine=empanada]: An empanada is a savory (or rarely sweet) meat pouch originating in Latin America.      
[cuisine=jamaican]: jamaican      
[cuisine=chinese;japanese]: chinese;japanese      
[cuisine=malagasy]: malagasy      
[cuisine=asian;sushi]: asian;sushi      
[cuisine=piadina]: piadina      
[cuisine=regional;international]: regional;international      
[cuisine=traditional]: traditional      
[cuisine=lao]: lao      
[cuisine=chinese;thai]: chinese;thai      
[cuisine=noodle;soba]: noodle;soba      
[cuisine=buffet]: buffet      
[cuisine=waffle]: A place sells mainly waffles      
[cuisine=regional;seafood]: regional;seafood      
[cuisine=yakiniku]: yakiniku      
[cuisine=cuban]: cuban      
[cuisine=hungarian]: hungarian      
[cuisine=sandwich;coffee_shop]: sandwich;coffee_shop      
[cuisine=coffee_shop;regional]: coffee_shop;regional      
[cuisine=coffee_shop;cake]: coffee_shop;cake      
[cuisine=uzbek]: uzbek      
[cuisine=deli]: deli      
[cuisine=breakfast;coffee_shop]: breakfast;coffee_shop      
[cuisine=burger;regional]: burger;regional      
[cuisine=nepalese]: nepalese      
[cuisine=soup]: A place that mainly sells soup. An example of this is stew.      
[cuisine=coffee_shop;vietnamese]: coffee_shop;vietnamese      
[cuisine=poke]: poke      
[cuisine=syrian]: syrian      
[cuisine=teahouse]: Usually tea with a light meal that can by accompanied various items, including tea sandwiches, clotted cream, cakes, scones, pancakes, crumpets and bread, butter and jam.      
[cuisine=japanese;chinese]: japanese;chinese      
[cuisine=ice_cream;coffee_shop]: ice_cream;coffee_shop      
[cuisine=burger;ice_cream]: burger;ice_cream      
[cuisine=coffee_shop;tea]: coffee_shop;tea      
[cuisine=french;regional]: french;regional      
[cuisine=japanese;ramen]: japanese;ramen      
[cuisine=chinese;asian]: chinese;asian      
[cuisine=hot_dog;burger]: hot_dog;burger      
[cuisine=regional;burger]: regional;burger      
[cuisine=cantonese]: cantonese      
[cuisine=pie]: pie      
[cuisine=falafel]: falafel      
[cuisine=italian;japanese]: italian;japanese      
[cuisine=czech]: czech      
[cuisine=burger;kebab]: burger;kebab      
[cuisine=brasserie]: brasserie      
[cuisine=savory_pancakes]: savory_pancakes      
[cuisine=afghan]: afghan      
[cuisine=italian_pizza;pizza]: italian_pizza;pizza      
[cuisine=asian;chinese]: asian;chinese      
[cuisine=swedish]: swedish      
[cuisine=pub]: pub      
[cuisine=crepe;russian]: crepe;russian      
[cuisine=snackbar]: snackbar      
[cuisine=breakfast;sandwich]: breakfast;sandwich      
[cuisine=snack]: snack      
[cuisine=burger;hot_dog]: burger;hot_dog      
[cuisine=pizza;buffet]: pizza;buffet      
[cuisine=bar&grill]: bar&grill      
[cuisine=crepes]: crepes      
[cuisine=fish;seafood]: fish;seafood      
[cuisine=kebab;burger]: kebab;burger      
[cuisine=pasta;pizza]: pasta;pizza      
[cuisine=italian;pizza;regional]: italian;pizza;regional      
[cuisine=pakistani]: A place that sells or distributes Pakistani food.      
[cuisine=ukrainian]: ukrainian      
[cuisine=teppanyaki]: teppanyaki      
[cuisine=belgian]: belgian      
[cuisine=pizza;sushi]: pizza;sushi      
[cuisine=seafood;regional]: seafood;regional      
[cuisine=pizza;burger;kebab]: pizza;burger;kebab      
[cuisine=chicken;barbecue]: chicken;barbecue      
[cuisine=chili]: chili      
[cuisine=malay]: malay      
[cuisine=smørrebrød]: smørrebrød      
[cuisine=salad;sandwich]: salad;sandwich      
[cuisine=italian;pizza;pasta]: italian;pizza;pasta      
[cuisine=spanish;tapas]: spanish;tapas      
[cuisine=brunch]: Restaurant primarily serves brunch.      
[cuisine=couscous]: Indicate that couscous is available in the restaurant or other food establishment.      
[cuisine=pastry]: pastry      
[cuisine=sandwich;burger]: sandwich;burger      
[cuisine=asian;vietnamese]: asian;vietnamese      
[cuisine=chinese;hot_pot]: chinese;hot_pot      
[cuisine=organic]: organic      
[cuisine=chinese;fish_and_chips]: chinese;fish_and_chips      
[cuisine=turkish;kebab]: turkish;kebab      
[cuisine=coffee_shop;breakfast]: coffee_shop;breakfast      
[cuisine=souvlaki]: souvlaki      
[cuisine=gyros]: gyros      
[cuisine=churro]: churro      
[cuisine=pizza;burger;sandwich]: pizza;burger;sandwich      
[cuisine=greek;mediterranean]: greek;mediterranean      
[cuisine=alpine_hut]: alpine_hut      
[cuisine=asian;thai]: asian;thai      
[cuisine=noodle; ramen]: noodle; ramen      
[cuisine=cajun]: cajun      
[cuisine=international;regional]: international;regional      
[cuisine=chocolate]: chocolate      
[cuisine=yakitori]: yakitori      
[cuisine=basque]: basque      
[cuisine=canteen]: canteen      
[cuisine=açaí]: açaí      
[cuisine=regional;local]: regional;local      
[cuisine=chicken;burger]: chicken;burger      
[cuisine=sandwich;salad]: sandwich;salad      
[cuisine=fish;regional]: fish;regional      
[cuisine=burger;kebab;pizza]: burger;kebab;pizza      
[cuisine=thai;asian]: thai;asian      
[cuisine=cake;malaysian]: cake;malaysian      
[cuisine=japanese;udon]: japanese;udon      
[cuisine=armenian]: armenian      
[cuisine=regional;sandwich]: regional;sandwich      
[cuisine=regional;fish]: regional;fish      
[cuisine=takoyaki]: takoyaki      
[cuisine=sushi;asian]: sushi;asian      
[cuisine=coffee_shop;bakery]: coffee_shop;bakery      
[cuisine=japanese;italian;french]: japanese;italian;french      
[cuisine=italian;pasta;pizza]: italian;pasta;pizza      
[cuisine=colombian]: colombian      
[cuisine=beef]: beef      
[cuisine=chinese;sushi]: chinese;sushi      
[cuisine=chinese;indian]: chinese;indian      
[cuisine=fondue]: fondue      
[cuisine=sandwich;pizza]: sandwich;pizza      
[cuisine=burger;steak_house]: burger;steak_house      
[cuisine=romanian]: romanian      
[cuisine=smoothie]: smoothie      
[cuisine=swiss]: swiss      
[cuisine=english]: english      
[cuisine=pastel]: pastel      
[cuisine=pizza;kebab;burger]: pizza;kebab;burger      
[cuisine=pizza;coffee_shop]: pizza;coffee_shop      
[cuisine=snacks]: snacks      
[cuisine=mongolian]: mongolian      
[cuisine=southern]: southern      
[cuisine=pizza;regional;italian]: pizza;regional;italian      
[cuisine=lunch]: lunch      
[cuisine=arabic]: arabic      
[cuisine=kebab;pizza;burger]: kebab;pizza;burger      
[cuisine=cafetaria]: cafetaria      
[cuisine=cake;coffee_shop;tea]: cake;coffee_shop;tea      
[cuisine=chinese;vietnamese]: chinese;vietnamese      
[cuisine=sandwich;breakfast]: sandwich;breakfast      
[cuisine=yes]: yes      
[cuisine=kebab;pizza;turkish]: kebab;pizza;turkish      
[cuisine=seafood;fish]: seafood;fish      
[cuisine=cookies]: cookies      
[cuisine=popcorn]: popcorn      
[cuisine=coffee_shop;malaysian]: coffee_shop;malaysian      
[cuisine=chinese;noodle]: chinese;noodle      
[cuisine=burger;coffee_shop]: burger;coffee_shop      
[cuisine=indian;pakistani]: indian;pakistani      
[cuisine=asian;japanese]: asian;japanese      
[cuisine=burger;fish_and_chips]: burger;fish_and_chips      
[cuisine=langos]: langos      
[cuisine=mamak]: mamak      
[cuisine=burger;pizza;sandwich]: burger;pizza;sandwich      
[cuisine=chinese;noodles]: chinese;noodles      
[cuisine=italian;mediterranean]: italian;mediterranean      
[cuisine=fusion]: fusion      
[cuisine=japanese;korean]: japanese;korean      
[cuisine=french;pizza]: french;pizza      
[cuisine=japanese;international]: japanese;international      
[cuisine=fish_and_chips;chinese]: fish_and_chips;chinese      
[cuisine=indian;nepalese]: indian;nepalese      
[cuisine=pizza;chicken]: pizza;chicken      
[cuisine=chicken;pizza]: chicken;pizza      
[cuisine=wine]: wine      
[cuisine=vietnamese;noodle]: vietnamese;noodle      
[cuisine=indian;pizza]: indian;pizza      
[cuisine=pizza;italian;regional]: pizza;italian;regional      
[cuisine=regional;mexican]: regional;mexican      
[cuisine=chinese;seafood]: chinese;seafood      
[cuisine=mexican;tacos]: mexican;tacos      
[cuisine=curry;indian]: curry;indian      
[cuisine=pizza;ice_cream]: pizza;ice_cream      
[cuisine=vietnamese;sandwich]: vietnamese;sandwich      
[cuisine=okonomiyaki]: okonomiyaki      
[cuisine=australian]: australian      
[cuisine=cafeteria]: cafeteria      
[cuisine=vietnamese;asian]: vietnamese;asian      
[cuisine=tibetan]: tibetan      
[cuisine=sandwiches]: sandwiches      
[cuisine=regional;chinese]: regional;chinese      
[cuisine=italian;pasta]: italian;pasta      
[cuisine=thai;vietnamese]: thai;vietnamese      
[cuisine=cake;ice_cream]: cake;ice_cream      
[cuisine=burger;breakfast]: burger;breakfast      
[cuisine=japanese;noodle]: japanese;noodle      
[cuisine=barbecue;regional]: barbecue;regional      
[cuisine=egyptian]: egyptian      
[cuisine=jewish]: jewish      
[cuisine=korean_food]: korean_food      
[cuisine=japanese;asian]: japanese;asian      
[cuisine=chinese;regional]: chinese;regional      
[cuisine=chinese;local]: chinese;local      
[cuisine=malaysian;chicken;burger]: malaysian;chicken;burger      
[cuisine=bulgarian]: bulgarian      
[cuisine=sri_lankan]: sri_lankan      
[cuisine=breakfast;lunch]: breakfast;lunch      
[cuisine=burger;friture]: burger;friture      
[cuisine=american;mexican]: american;mexican      
[cuisine=local;regional]: local;regional      
[cuisine=pizza;turkish]: pizza;turkish      
[cuisine=coffee_shop;pizza]: coffee_shop;pizza      
[cuisine=tea_shop]: Specifies that a location is most known for its tea.      
[cuisine=pizza;italian_pizza]: pizza;italian_pizza      
[cuisine=regional;steak_house]: regional;steak_house      
[cuisine=german;greek]: german;greek      
[cuisine=bento]: bento      
[cuisine=french;american;european]: french;american;european      
[cuisine=pizza;french]: pizza;french      
[cuisine=chicken;american]: chicken;american      
[cuisine=pizza;grill]: pizza;grill      
[cuisine=ramen;japanese]: ramen;japanese      
[cuisine=steak_house;seafood]: steak_house;seafood      
[cuisine=coffee_shop;coffee]: coffee_shop;coffee      
[cuisine=regional;asian]: regional;asian      
[cuisine=german;italian]: german;italian      
[cuisine=korean;barbecue]: korean;barbecue      
[cuisine=taco]: taco      
[cuisine=crepe;ice_cream]: crepe;ice_cream      
[cuisine=お好み焼き]: お好み焼き      
[cuisine=greek;grill]: greek;grill      
[cuisine=noodle;udon]: noodle;udon      
[cuisine=regional;pizza;italian]: regional;pizza;italian      
[cuisine=kebab;burger;pizza]: kebab;burger;pizza      
[cuisine=dutch]: dutch      
[cuisine=bread]: bread      
[cuisine=steak_house;burger]: steak_house;burger      
[cuisine=coffee_shop;italian]: coffee_shop;italian      
[cuisine=tea;cake;coffee_shop]: tea;cake;coffee_shop      
[cuisine=焼肉]: 焼肉      
[cuisine=american;barbecue]: american;barbecue      
[cuisine=serbian]: serbian      
[cuisine=senegalese]: senegalese      
[cuisine=kebab; pizza]: kebab; pizza      
[cuisine=polish;regional]: polish;regional      
[cuisine=gastropub]: gastropub      
[cuisine=vietnamese;thai]: vietnamese;thai      
[cuisine=american;seafood]: american;seafood      
[cuisine=teriyaki]: teriyaki      
[cuisine=asian;korean]: asian;korean      
[cuisine=unagi]: unagi      
[cuisine=regional;chicken]: regional;chicken      
[cuisine=italian;coffee_shop]: italian;coffee_shop      
[cuisine=italian;german]: italian;german      
[cuisine=salads]: salads      
[cuisine=pizza;seafood]: pizza;seafood      
[cuisine=pizza;italian;pasta]: pizza;italian;pasta      
[cuisine=ice_cream;pizza]: ice_cream;pizza      
[cuisine=mexican;regional]: mexican;regional      
[cuisine=pizza;pasta;italian]: pizza;pasta;italian      
[cuisine=bangladeshi]: bangladeshi      
[cuisine=italian;seafood]: italian;seafood      
[cuisine=bar]: bar      
[cuisine=greek;german]: greek;german      
[cuisine=french;italian]: french;italian      
[cuisine=ramen;jiro]: ramen;jiro      
[cuisine=mexican;seafood]: mexican;seafood      
[cuisine=burger;mexican]: burger;mexican      
[cuisine=pizza;american]: pizza;american      
[cuisine=american;steak;buffet]: american;steak;buffet      
[cuisine=pizza;burger;regional]: pizza;burger;regional      
[cuisine=cambodian]: cambodian      
[cuisine=doner]: doner      
[cuisine=mexican;tex-mex]: mexican;tex-mex      
[cuisine=pizza;empanada]: pizza;empanada      
[cuisine=indian;curry]: indian;curry      
[cuisine=italian;french]: italian;french      
[cuisine=ramen;noodle]: ramen;noodle      
[cuisine=greek;regional]: greek;regional      
[cuisine=chicken;regional]: chicken;regional      
[cuisine=burrito]: burrito      
[cuisine=thai;chinese]: thai;chinese      
[cuisine=sandwich;regional]: sandwich;regional      
[cuisine=indian;italian]: indian;italian      
[cuisine=poutine]: poutine      
[cuisine=sandwich;ice_cream]: sandwich;ice_cream      
[cuisine=chinese;cantonese]: chinese;cantonese      
[cuisine=seafood;mexican]: seafood;mexican      
[cuisine=italian;sandwich]: italian;sandwich      
[cuisine=vegan]: vegan      
[cuisine=chinese;ramen]: chinese;ramen      
[cuisine=american;ice_cream]: american;ice_cream      
[cuisine=japanese;seafood]: japanese;seafood      
[cuisine=smoothies]: smoothies      
[cuisine=chinese;hotpot]: chinese;hotpot      
[cuisine=greek;italian]: greek;italian      
[cuisine=venezuelan]: venezuelan      
[cuisine=pizza;steak_house]: pizza;steak_house      
[cuisine=regional;greek]: regional;greek      
[cuisine=kebab;chicken]: kebab;chicken      
[cuisine=pancakes]: pancakes      
[cuisine=korean;japanese]: korean;japanese      
[cuisine=burger;sandwich;chicken]: burger;sandwich;chicken      
[cuisine=italian;local]: italian;local      
[cuisine=ice_cream;cake]: ice_cream;cake      
[cuisine=regional;indian]: regional;indian      
[cuisine=indian;chinese]: indian;chinese      
[cuisine=noodle;japanese]: noodle;japanese      
[cuisine=vegan;vegetarian]: vegan;vegetarian      
[cuisine=barbecue;korean]: barbecue;korean      
[cuisine=turkish;pizza]: turkish;pizza      
[cuisine=regional;tapas]: regional;tapas      
[cuisine=friture;japanese]: friture;japanese      
[cuisine=coffee_shop;international]: coffee_shop;international      
[cuisine=Sagardotegia]: Sagardotegia      
[cuisine=japanese;teppanyaki;steak]: japanese;teppanyaki;steak      
[cuisine=fish_and_chips;burger]: fish_and_chips;burger      
[cuisine=burger;coffee_shop;sandwich]: burger;coffee_shop;sandwich      
[cuisine=american;regional]: american;regional      
[cuisine=pork]: pork      
[cuisine=italian;ice_cream]: italian;ice_cream      
[cuisine=rotisserie]: rotisserie      
[cuisine=seafood;steak_house]: seafood;steak_house      
[cuisine=regional;polish]: regional;polish      
[cuisine=pizza;indian]: pizza;indian      
[cuisine=sandwich;salad;regional]: sandwich;salad;regional      
[cuisine=regional;mediterranean]: regional;mediterranean      
[cuisine=fish_and_chips;pizza]: fish_and_chips;pizza      
[cuisine=greek;pizza]: greek;pizza      
[cuisine=cake;coffee_shop;ice_cream]: cake;coffee_shop;ice_cream      
[cuisine=chinese;breakfast]: chinese;breakfast      
[cuisine=vietnamese;chinese]: vietnamese;chinese      
[cuisine=indian;bangladeshi]: indian;bangladeshi      
[cuisine=international;local]: international;local      
[cuisine=chips]: chips      
[cuisine=regional;heuriger]: regional;heuriger      
[cuisine=africaine]: africaine      
[cuisine=chicken;korean;sushi]: chicken;korean;sushi      
[cuisine=gourmet]: gourmet      
[cuisine=regional;italian;pizza]: regional;italian;pizza      
[cuisine=kebab;regional]: kebab;regional      
[cuisine=asian;regional]: asian;regional      
[cuisine=vietnamese;sushi]: vietnamese;sushi      
[cuisine=american;pizza]: american;pizza      
[cuisine=chifa]: chifa      
[cuisine=fish_and_chips;kebab]: fish_and_chips;kebab      
[cuisine=chocolate;ice_cream;popcorn]: chocolate;ice_cream;popcorn      
[cuisine=cafe/diner]: cafe/diner      
[cuisine=pasta;italian]: pasta;italian      
[cuisine=thai;sushi]: thai;sushi      
[cuisine=drinks]: drinks      
[cuisine=coffee;cake]: coffee;cake      
[cuisine=no]: no      
[cuisine=coffee_shop;donut]: coffee_shop;donut      
[cuisine=tapas;spanish]: tapas;spanish      
[cuisine=spanish;regional]: spanish;regional      
[cuisine=bowl]: bowl      
[cuisine=regional;spanish]: regional;spanish      
[cuisine=indian;regional]: indian;regional      
[cuisine=yogurt]: yogurt      
[cuisine=coffee_shop;french]: coffee_shop;french      
[cuisine=creole]: creole      
[cuisine=regional;ice_cream]: regional;ice_cream      
[cuisine=burger;pizza;kebab]: burger;pizza;kebab      
[cuisine=regional;portuguese]: regional;portuguese      
[cuisine=regional;barbecue]: regional;barbecue      
[cuisine=salvadoran]: salvadoran      
[cuisine=chinese;buffet]: chinese;buffet      
[cuisine=coffee_shop;local]: coffee_shop;local      
[cuisine=breakfast;local]: breakfast;local      
[cuisine=scandinavian]: scandinavian      
[cuisine=coffee_shop;sandwich;ice_cream]: coffee_shop;sandwich;ice_cream      
[cuisine=regional;grill]: regional;grill      
[cuisine=other]: other      
[cuisine=steak_house;pizza]: steak_house;pizza      
[cuisine=barbeque]: barbeque      
[cuisine=seafood;local]: seafood;local      
[cuisine=regional;american]: regional;american      
[cuisine=burger;grill]: burger;grill      
[cuisine=breakfast;american]: breakfast;american      
[cuisine=regional;kebab]: regional;kebab      
[cuisine=german;international]: german;international      
[cuisine=barbecue;chicken]: barbecue;chicken      
[cuisine=galician]: galician      
[cuisine=coffee_shop;chinese]: coffee_shop;chinese      
[cuisine=asian;kebab]: asian;kebab      
[cuisine=coffee_shop;burger]: coffee_shop;burger      
[cuisine=hot_pot]: A place that mainly sells hot pots.      
[cuisine=greek;seafood]: greek;seafood      
[cuisine=coffee_shop;dessert]: coffee_shop;dessert      
[cuisine=tunisian]: tunisian      
[cuisine=pizza;wings]: pizza;wings      
[cuisine=american;sandwich]: american;sandwich      
[cuisine=sushi;pizza]: sushi;pizza      
[cuisine=fish;local]: fish;local      
[cuisine=indian;asian]: indian;asian      
[cuisine=burger;pizza;regional]: burger;pizza;regional      
[cuisine=caucasian]: caucasian      
[cuisine=pizza;burger;meat;pasta]: pizza;burger;meat;pasta      
[cuisine=indonesian;local]: indonesian;local      
[cuisine=roasted_chicken]: roasted_chicken      
[cuisine=coffee_shop;pastry]: coffee_shop;pastry      
[cuisine=french;seafood]: french;seafood      
[cuisine=seafood;american]: seafood;american      
[cuisine=corsican]: corsican      
[cuisine=chicken;kebab]: chicken;kebab      
[cuisine=dominican]: dominican      
[cuisine=beer]: beer      
[cuisine=ice_cream;coffee]: ice_cream;coffee      
[cuisine=chimney_cake]: chimney_cake      
[cuisine=mexican;american]: mexican;american      
[cuisine=philippine]: philippine      
[cuisine=italian;indian]: italian;indian      
[cuisine=french;local]: french;local      
[cuisine=sushi;chinese]: sushi;chinese      
[cuisine=breakfast;cake;coffee_shop]: breakfast;cake;coffee_shop      
[cuisine=chicken;korean]: chicken;korean      
[cuisine=barbecue;pizza]: barbecue;pizza      
[cuisine=regional;pizza;burger]: regional;pizza;burger      
[cuisine=barbecue;burger]: barbecue;burger      
[cuisine=international;pizza]: international;pizza      
[cuisine=steak_house;barbecue]: steak_house;barbecue      
[cuisine=burger;regional;sandwich]: burger;regional;sandwich      
[cuisine=cake;breakfast;coffee_shop]: cake;breakfast;coffee_shop      
[cuisine=chinese;japanese;sushi]: chinese;japanese;sushi      
[cuisine=sushi;thai]: sushi;thai      
[cuisine=pizza;greek]: pizza;greek      
[cuisine=pizza;pasta;sandwich]: pizza;pasta;sandwich      
[cuisine=japanese;thai]: japanese;thai      
[cuisine=pizza;salad]: pizza;salad      
[cuisine=soul_food]: soul_food      
[cuisine=italian;italian_pizza;pizza]: italian;italian_pizza;pizza      
[cuisine=japanese;barbecue]: japanese;barbecue      
[cuisine=breakfast;brunch]: breakfast;brunch      
[cuisine=うどん]: うどん      
[cuisine=regional;thai]: regional;thai      
[cuisine=italian;international]: italian;international      
[cuisine=burger;barbecue]: burger;barbecue      
[cuisine=catalan]: A place that mainly sells Catalan food.      
[cuisine=south_indian]: south_indian      
[cuisine=sushi;vietnamese]: sushi;vietnamese      
[cuisine=italian;fish]: italian;fish      
[cuisine=italian;noodle;pizza]: italian;noodle;pizza      
[cuisine=pizza;international]: pizza;international      
[cuisine=chicken;falafel;gyros]: chicken;falafel;gyros      
[cuisine=barbecue;steak_house]: barbecue;steak_house      
[cuisine=indian;south_indian]: indian;south_indian      
[cuisine=pizza;barbecue]: pizza;barbecue      
[cuisine=american;steak_house]: american;steak_house      
[cuisine=american;diner]: american;diner      
[cuisine=fish;fish_and_chips]: fish;fish_and_chips      
[cuisine=mediterranean;italian]: mediterranean;italian      
[cuisine=chinese;coffee_shop]: chinese;coffee_shop      
[cuisine=burger;fries]: burger;fries      
[cuisine=ice_cream;sandwich]: ice_cream;sandwich      
[cuisine=regional;coffee_shop;sandwich]: regional;coffee_shop;sandwich      
[cuisine=soup;sandwich]: soup;sandwich      
[cuisine=burger;international]: burger;international      
[cuisine=thai;seafood]: thai;seafood      
[cuisine=israeli]: israeli      
[cuisine=japanese;soba]: japanese;soba      
[cuisine=ラーメン]: ラーメン      
[cuisine=ramen;chinese]: ramen;chinese      
[cuisine=asian;indian]: asian;indian      
[cuisine=sandwich;breakfast;coffee_shop]: sandwich;breakfast;coffee_shop      
[cuisine=indian;thai]: indian;thai      
[cuisine=japanese;regional]: japanese;regional      
[cuisine=pakistani;indian]: pakistani;indian      
[cuisine=pizza;regional;burger]: pizza;regional;burger      
[cuisine=寿司]: 寿司      
[cuisine=fish;pizza]: fish;pizza      
[cuisine=regional;japanese]: regional;japanese      
[cuisine=burger;german]: burger;german      
[cuisine=american;pub]: american;pub      
[cuisine=nepalese;indian]: nepalese;indian      
[cuisine=burger;pizza;seafood]: burger;pizza;seafood      
[cuisine=turkish;italian]: turkish;italian      
[cuisine=fish;italian]: fish;italian      
[cuisine=seafood;steak]: seafood;steak      
[cuisine=chinese;dumplings]: chinese;dumplings      
[cuisine=burger;italian]: burger;italian      
[cuisine=barbecue;hawaiian]: barbecue;hawaiian      
[cuisine=thai;local]: thai;local      
[cuisine=seafood;thai]: seafood;thai      
[cuisine=regional;burger;sandwich]: regional;burger;sandwich      
[cuisine=coffee;tea]: coffee;tea      
[cuisine=とんかつ]: とんかつ      
[cuisine=chicken;grill]: chicken;grill      
[cuisine=burger;sausage]: burger;sausage      
[cuisine=coffee_shop;cafe]: coffee_shop;cafe      
[cuisine=chicken;fish]: chicken;fish      
[cuisine=cookie]: cookie      
[cuisine=burger;sandwich;coffee_shop]: burger;sandwich;coffee_shop      
[cuisine=Pizza]: Pizza      
[cuisine=swabian]: swabian      
[cuisine=asian;japanese;sushi]: asian;japanese;sushi      
[cuisine=american;italian]: american;italian      
[cuisine=pho]: pho      
[cuisine=tacos;mexican]: tacos;mexican      
[cuisine=早餐]: 早餐      
[cuisine=kebab;persian]: kebab;persian      
[cuisine=pizza;burger;italian]: pizza;burger;italian      
[cuisine=regional;breakfast]: regional;breakfast      
[cuisine=crepe;pancake]: crepe;pancake      
[cuisine=ice_cream;italian]: ice_cream;italian      
[cuisine=seafood;chinese]: seafood;chinese      
[cuisine=grill;pasta;pizza]: grill;pasta;pizza      
[cuisine=health_food]: health_food      
[cuisine=bagel;sandwich]: bagel;sandwich      
[cuisine=thai;international]: thai;international      
[cuisine=regional;sardinian]: regional;sardinian      
[cuisine=banitsa]: banitsa      
[cuisine=spanish;mediterranean]: spanish;mediterranean      
[cuisine=tonkatsu]: tonkatsu      
[cuisine=italian;turkish]: italian;turkish      
[cuisine=italian_pizza;italian;pizza]: italian_pizza;italian;pizza      
[cuisine=crepe;pizza]: crepe;pizza      
[cuisine=regional;russian]: regional;russian      
[cuisine=kebab;shawarma]: kebab;shawarma      
[cuisine=burger;seafood]: burger;seafood      
[cuisine=kebab;falafel]: kebab;falafel      
[cuisine=canadian]: canadian      
[cuisine=chinese;indonesian]: chinese;indonesian      
[cuisine=crepe;french]: crepe;french      
[cuisine=chinese;malaysian]: chinese;malaysian      
[cuisine=burger;french]: burger;french      
[cuisine=cake;coffee_shop;sandwich]: cake;coffee_shop;sandwich      
[cuisine=french;mediterranean]: french;mediterranean      
[cuisine=seafood;pizza]: seafood;pizza      
[cuisine=regional;czech]: regional;czech      
[cuisine=sandwich;vietnamese]: sandwich;vietnamese      
[cuisine=coffee_shop;breakfast;sandwich]: coffee_shop;breakfast;sandwich      
[cuisine=suki]: suki      
[cuisine=cheese]: cheese      
[cuisine=iranian]: iranian      
[cuisine=grill;local]: grill;local      
[cuisine=italian; pizza]: italian; pizza      
[cuisine=steak_house;regional]: steak_house;regional      
[cuisine=friture;burger]: friture;burger      
[cuisine=gaucho]: gaucho      
[cuisine=sandwich;american]: sandwich;american      
[cuisine=kebab;sandwich]: kebab;sandwich      
[cuisine=barbecue;grill]: barbecue;grill      
[cuisine=french;burger]: french;burger      
[cuisine=pizza;italian;burger]: pizza;italian;burger      
[cuisine=burger;fast_food]: burger;fast_food      
[cuisine=local;coffee_shop]: local;coffee_shop      
[cuisine=macedonian]: macedonian      
[cuisine=burger;escalope;german]: burger;escalope;german      
[cuisine=international;italian]: international;italian      
[cuisine=nordic]: nordic      
[cuisine=local;french]: local;french      
[cuisine=火鍋]: 火鍋      
[cuisine=italian;greek]: italian;greek      
[cuisine=malaysian;thai]: malaysian;thai      
[cuisine=chinese;pizza]: chinese;pizza      
[cuisine=burger;steak]: burger;steak      
[cuisine=noodle; soba]: noodle; soba      
[cuisine=portuguese;regional]: portuguese;regional      
[cuisine=そば]: そば      
[cuisine=azerbaijan]: azerbaijan      
[cuisine=pizza;burger;chicken]: pizza;burger;chicken      
[cuisine=pizza;burger;american]: pizza;burger;american      
[cuisine=italian;steak_house]: italian;steak_house      
[cuisine=pizza;pasta;burger]: pizza;pasta;burger      
[cuisine=italian_pizza;local]: italian_pizza;local      
[cuisine=japanese;noodles]: japanese;noodles      
[cuisine=myanmar]: myanmar      
[cuisine=coffee_shop;american]: coffee_shop;american      
[cuisine=sandwich;salad;juice]: sandwich;salad;juice      
[cuisine=healthy;sandwich;salad;pie]: healthy;sandwich;salad;pie      
[cuisine=tea;breakfast;coffee_shop]: tea;breakfast;coffee_shop      
[cuisine=local;seafood]: local;seafood      
[cuisine=coffee_shop;burger;sandwich]: coffee_shop;burger;sandwich      
[cuisine=coffee_shop;thai]: coffee_shop;thai      
[cuisine=italian;regional;pizza]: italian;regional;pizza      
[cuisine=balkan;regional]: balkan;regional      
[cuisine=cake;sandwich]: cake;sandwich      
[cuisine=sandwich;italian]: sandwich;italian      
[cuisine=singaporean]: singaporean      
[cuisine=local;pizza]: local;pizza      
[cuisine=new_mexican]: new_mexican      
[cuisine=gyoza]: gyoza      
[cuisine=たこ焼き]: たこ焼き      
[cuisine=wok]: wok      
[cuisine=mediterranean;pizza]: mediterranean;pizza      
[cuisine=regional;balkan]: regional;balkan      
[cuisine=seafood;italian]: seafood;italian      
[cuisine=indonesian;international]: indonesian;international      
[cuisine=bavarian;regional]: bavarian;regional      
[cuisine=baguette]: baguette      
[cuisine=hamburger]: hamburger      
[cuisine=korean;bbq]: korean;bbq      
[cuisine=chicken;pizza;pasta]: chicken;pizza;pasta      
[cuisine=german;burger]: german;burger      
[cuisine=bavarian;german]: bavarian;german      
[cuisine=noodles;thai]: noodles;thai      
[cuisine=steak_house;american]: steak_house;american      
[cuisine=kebab;barbecue]: kebab;barbecue      
[cuisine=italian;burger]: italian;burger      
[cuisine=polish;international]: polish;international      
[cuisine=grill;pizza]: grill;pizza      
[cuisine=mexican;pizza]: mexican;pizza      
[cuisine=puerto_rican]: puerto_rican      
[cuisine=burger;salad]: burger;salad      
[cuisine=mediterranean;turkish]: mediterranean;turkish      
[cuisine=Cachapas_y_Queso]: Cachapas_y_Queso      
[cuisine=coffee_shop;cake;ice_cream]: coffee_shop;cake;ice_cream      
[cuisine=steak_house;argentinian]: steak_house;argentinian      
[cuisine=international;thai]: international;thai      
[cuisine=Ψητοπωλείο]: Ψητοπωλείο      
[cuisine=italian_pizza;pasta]: italian_pizza;pasta      
[cuisine=regional;turkish]: regional;turkish      
[cuisine=healthy]: healthy      
[cuisine=cantonese;western]: cantonese;western      
[cuisine=japanese;sushi;asian]: japanese;sushi;asian      
[cuisine=burmese]: burmese      
[cuisine=italian;mexican]: italian;mexican      
[cuisine=nepali]: nepali      
[cuisine=pizza;burger;coffee_shop]: pizza;burger;coffee_shop      
[cuisine=lithuanian]: lithuanian      
[cuisine=sicilian]: sicilian      
[cuisine=burger;chicken;kebab;pizza]: burger;chicken;kebab;pizza      
[cuisine=milkshake]: milkshake      
[cuisine=rice]: rice      
[cuisine=regional;fish_and_chips]: regional;fish_and_chips      
[cuisine=ice_cream;coffee_shop;cake]: ice_cream;coffee_shop;cake      
[cuisine=sardinian]: sardinian      
[cuisine=steak_house;grill]: steak_house;grill      
[cuisine=fish_and_chips;seafood]: fish_and_chips;seafood      
[cuisine=pizza;italian;sandwich]: pizza;italian;sandwich      
[cuisine=chinese;chicken]: chinese;chicken      
[cuisine=seafood;french]: seafood;french      
[cuisine=greek;fish]: greek;fish      
[cuisine=italian;pizza;burger]: italian;pizza;burger      
[cuisine=italian;american]: italian;american      
[cuisine=seafood;burger]: seafood;burger      
[cuisine=mediterranean;greek]: mediterranean;greek      
[cuisine=franconian]: franconian      
[cuisine=rice_dumpling]: rice_dumpling      
[cuisine=bougatsa]: bougatsa      
[cuisine=カレー]: カレー      
[cuisine=indian;international]: indian;international      
[cuisine=burger;local]: burger;local      
[cuisine=coconut]: coconut      
[cuisine=hot_dog;pizza;sandwich]: hot_dog;pizza;sandwich      
[cuisine=breakfast;international]: breakfast;international      
[shop=convenience]: A convenience shop is a small local shop carrying a variety of everyday products, such as packaged food and hygiene products      
[shop=supermarket]: A large shop selling groceries, fresh produce, and other goods.      
[shop=clothes]: A shop which primarily sells clothing      
[shop=hairdresser]: A hairdressers or barbers shop, where hair is cut      
[shop=car_repair]: A business where cars are repaired.      
[shop=bakery]: A shop selling bread      
[shop=yes]: A shop of unspecified type or indicator that feature such as fuel station has shop.      
[shop=car]: A place that primarily sells cars (automobiles)      
[shop=beauty]: A non-hairdresser beauty shop, spa, nail salon, etc.      
[shop=kiosk]: A small shop on the pavement that sells magazines, tobacco, newspapers, sweets and stamps.      
[shop=mobile_phone]: A shop that primarily sells mobile phones and accessories.      
[shop=butcher]: A shop selling meat or meat products.      
[shop=hardware]: A shop which sells timber, tools and other building products      
[shop=furniture]: A shop selling furniture.      
[shop=car_parts]: A place selling auto parts, auto accessories, motor oil, car chemicals, etc.      
[shop=alcohol]: A shop selling alcoholic drinks      
[shop=electronics]: A shop selling consumer electronics such as TVs, radios and fridges.      
[shop=florist]: A shop selling bouquets of flowers      
[shop=shoes]: A shop selling shoes      
[shop=mall]: A group of stores, typically associated with a single building structure.      
[shop=variety_store]: A variety store or price-point retailer is a retail shop that sells inexpensive items      
[shop=optician]: A shop that sells, fits, and repairs prescription eyeglasses and contact lenses.      
[shop=doityourself]: A Do-it-Yourself-store, a large hardware and home improvement shop      
[shop=jewelry]: A shop that sells rings, necklaces, earrings, watches, etc.      
[shop=gift]: Shop selling gifts, greeting cards, or tourist gifts (souvenirs).      
[shop=greengrocer]: A shop which sells fruits and vegetables      
[shop=books]: A store specializing in the sale of books, although it may also sell other printed publications, such as newspapers and magazines      
[shop=bicycle]: A store where you can buy and/or repair your bike and buy accessories      
[shop=department_store]: A large store with multiple clothing and other general merchandise departments.      
[shop=chemist]: A shop selling articles of personal hygiene, cosmetics, and household cleaning products.      
[shop=travel_agency]: A shop selling travel related products and services      
[shop=laundry]: A shop to wash clothes and bedding, generally self-service and unattended.      
[shop=sports]: A shop selling sports equipment and clothing.      
[shop=pet]: A shop selling pets and/or pet supplies      
[shop=stationery]: A shop selling office supplies      
[shop=confectionery]: A shop selling sweets and candies.      
[shop=vacant]: Shop that is currently not being used.      
[shop=computer]: A shop selling computers, peripherals, software, ...      
[shop=tyres]: A shop selling tyres      
[shop=tailor]: A place where clothing is made, repaired, or altered professionally, especially suits and men's clothing.      
[shop=dry_cleaning]: A shop or kiosk offering a clothes dry cleaning service.      
[shop=cosmetics]: Shop exclusively selling cosmetics      
[shop=newsagent]: A shop selling newspapers and magazines.      
[shop=beverages]: Shop focused on selling beverages and drinks, possibly including alcoholic and non-alcoholic ones.      
[shop=motorcycle]: A shop that sells motorcycles and/or related accessories and services.      
[shop=copyshop]: A shop that offers photocopying and printing services.      
[shop=funeral_directors]: Providing services related to funeral arrangements, may also be known as a \funeral parlour\ or \undertakers\.      
[shop=garden_centre]: A shop selling potted plants, seedlings for planting, and related items.      
[shop=tobacco]: A shop selling tobacco, and possibly other convenience items      
[shop=farm]: A shop at a farm, selling farm produce.      
[shop=storage_rental]: paid storage of household goods, i.e. self storage      
[shop=trade]: A place of business that sells to a particular trade or trades, but normally also retails to normal consumers.      
[shop=toys]: A shop focussed on selling children's toys.      
[shop=deli]: A delicatessen store      
[shop=massage]: Massage shop      
[shop=interior_decoration]: Shop focused on selling interior decorations      
[shop=seafood]: A shop selling fish/seafood.      
[shop=ticket]: A shop selling tickets for concerts, events, public transport, ...      
[shop=outpost]: Shop primarily used to pick-up items ordered online. May have meager supply of products.      
[shop=pastry]: A shop where sweet bakery products are produced and sold      
[shop=houseware]: A shop selling small household items      
[shop=general]: A general store. Small shop selling variety of different products.      
[shop=wine]: Shop selling wine      
[shop=photo]: A shop dealing with photos or video in any way.      
[shop=paint]: A shop where you can buy paints.      
[shop=outdoor]: A shop selling trekking, climbing, camping equipment.      
[shop=charity]: A shop operated by a charity      
[shop=pawnbroker]: A business that offers secured loans against items of personal property as collateral.      
[shop=art]: A shop which sells works of art.      
[shop=bookmaker]: A shop that takes bets on sporting and other events at agreed upon odds.      
[shop=tattoo]: A place where people can get permanent tattoos      
[shop=medical_supply]: A store where you can buy medical equipment for private persons.      
[shop=second_hand]: A shop selling second hand goods      
[shop=kitchen]: A shop where you can plan and buy your kitchen.      
[shop=bed]: A shop that specialises in selling mattresses and other bedding products.      
[shop=fabric]: A shop that sells fabric      
[shop=lottery]: A shop of which the main or only purpose is the sale of lottery tickets.      
[shop=wholesale]: A store that sells items in bulk.      
[shop=antiques]: A shop where you can buy antiques      
[shop=boutique]: A small shop that sells expensive or designer clothing and/or accessories.      
[shop=gas]: A shop selling and/or refilling bottled gas.      
[shop=craft]: A place where customers can buy supplies for making art and crafts.      
[shop=coffee]: A shop selling coffee      
[shop=perfumery]: A shop selling perfumes.      
[shop=hearing_aids]: A shop specialized in selling hearing aids devices      
[shop=tea]: Shop selling tea      
[shop=agrarian]: Shop selling products for agricultural use, such as pesticides, seeds, animal feed, etc.      
[shop=e-cigarette]: A shop selling electronic cigarettes      
[shop=baby_goods]: A shop where you can buy objects for babies, like clothes, prams, cots or baby's baths      
[shop=money_lender]: Shop offering small personal loans at high rates of interest      
[shop=musical_instrument]: Shop selling musical instruments, lyrics, scores.      
[shop=music]: A store that primarily sells recorded music (vinyl/CDs)      
[shop=bag]: A shop selling bags.      
[shop=appliance]: Shop for white goods      
[shop=electrical]: Shop selling electrical supplies and devices.      
[shop=carpet]: A shop selling carpets.      
[shop=dairy]: A shop selling dairy products.      
[shop=motorcycle_repair]: A place where you can get your motorcycles repaired.      
[shop=video_games]: Shop selling video games.      
[shop=cheese]: A shop mainly selling cheese.      
[shop=chocolate]: Shop focused on selling chocolate.      
[shop=hifi]: Shop selling high fidelity audio components      
[shop=health_food]: A health food shop; selling wholefoods, vitamins, nutrition supplements and meat and dairy alternatives.      
[shop=grocery]: A retail store that specializes in selling non-perishable food.      
[shop=fishing]: Store where you can buy fishing equipment.      
[shop=pet_grooming]: A shop offering grooming services for pets (most frequently dogs)      
[shop=locksmith]: A shop where you can get keys cut      
[shop=video]: A shop that sells or rents out videos/DVDs      
[shop=nutrition_supplements]: Shops that sells nutritional supplements different types of purified proteins, fats, vitamins, minerals and/or herbs.      
[shop=estate_agent]: A shop which sells and/or rents property.      
[shop=bathroom_furnishing]: A shop selling bathroom furnishings.      
[shop=curtain]: A shop that specialises in selling curtains or drapes.      
[shop=erotic]: A shop selling erotic products such as sex toys, erotic lingerie, fetish clothing, safe sex products, erotic games and gifts, and pornographic films and magazines      
[shop=watches]: A shop that sells watches.      
[shop=rental]: A shop that rents different kinds vehicles or (sport) equipment.      
[shop=fashion_accessories]: A shop focused on selling fashion accessories      
[shop=sewing]: A shop that sells sewing supplies (fabric, thread, yarn, knitting needles, sewing machines, etc.)      
[shop=frame]: A shop where you can buy frames.      
[shop=herbalist]: Shop focused on selling herbs, often for medical purposes      
[shop=cannabis]: A shop primarily and legally selling cannabis products.      
[shop=frozen_food]: A shop that mainly sells frozen food.      
[shop=no]: Indicator that feature such as fuel station has no shop, nowadays generally not used.      
[shop=lighting]: A shop selling lighting fixtures and lamps.      
[shop=convenience;gas]: convenience;gas      
[shop=party]: Shop selling party supplies like decorations, invitations and costumes.      
[shop=tiles]: A store that sells tiles      
[shop=religion]: A shop selling merchandise related to religion      
[shop=food]: A shop selling food.      
[shop=doors]: A place that specializes in selling only or mainly doors.      
[shop=shoe_repair]: A place where one may have shoes repaired or altered.      
[shop=water]: A shop focused on selling drinking water.      
[shop=flooring]: A shop which sells a variety of floorings      
[shop=leather]: A shop for products made out of leather      
[shop=hairdresser_supply]: A shop where you can buy hairdressing supplies      
[shop=weapons]: Shop focused on selling weapons like knives, guns, etc.      
[shop=ice_cream]: For places selling ice cream.      
[shop=radiotechnics]: Shop focused on selling electronic components, electrical products, radio measuring devices, supplies for radio and electronics.      
[shop=swimming_pool]: A store that sells swimming pool equipment and supplies      
[shop=telecommunication]: A shop of a telecommunications company      
[shop=country_store]: A Country Store is a UK term for a shop selling a range of goods specifically aimed at country dwellers.      
[shop=glaziery]: Selling and installing glazing for windows and doors.      
[shop=fashion]: Fashion shop      
[shop=boat]: A boat shop, may also offer further services.      
[shop=games]: Shop selling board games.      
[shop=fireplace]: A shop selling fireplaces.      
[shop=scuba_diving]: A shop that sells eqipment for scuba diving and/or related accessories and services      
[shop=window_blind]: A shop that sells window blinds.      
[shop=fuel]: A shop selling fuels      
[shop=repair]: Used for repair shops.      
[shop=caravan]: A shop for caravans, motorhomes & similar recreational vehicles      
[shop=printing]: A shop for printing documents      
[shop=pottery]: A place where earthenware, stoneware and porcelain and other ceramic ware are sold.      
[shop=pyrotechnics]: Shop selling consumer pyrotechnics: fireworks, firecrackers, sparklers etc.      
[shop=spices]: A shop selling spices      
[shop=hobby]: hobby      
[shop=vacuum_cleaner]: A shop that sales vacuum cleaners      
[shop=tool_hire]: A shop hiring out tools.      
[shop=photo_studio]: photo_studio      
[shop=hunting]: Shop where you can buy gun and hunting equipment.      
[shop=building_materials]: building_materials      
[shop=collector]: A shop that focuses on selling collector's items, like stamps, coins, action figures, etc.      
[shop=printer_ink]: A shop that sells or refills printer ink cartridges.      
[shop=model]: A shop selling scale models.      
[shop=security]: Stores selling security equipment: surveillance cameras, firefighting equipment, alarm systems, warning systems, etc.      
[shop=camera]: A shop mainly selling cameras and lenses      
[shop=household_linen]: A shop that sells household linen.      
[shop=candles]: Shop focused on selling candles and candle accessories (holders, etc)      
[shop=catalogue]: catalogue      
[shop=water_sports]: A shop sells items for water sports activities.      
[shop=pasta]: Shop focused on selling (fresh) pasta, ravioli, etc.      
[shop=honey]: A shop selling honey.      
[shop=car;car_repair]: car;car_repair      
[shop=energy]: Shop selling equipment and supplies for generating energy, such as solar panels or butane cylinders.      
[shop=accessories]: accessories      
[shop=haberdashery]: Haberdashery - shop selling small articles for sewing, such as buttons, ribbons, zips.      
[shop=anime]: A shop that sells anime and related items.      
[shop=trophy]: Shop selling trophies, awards, plaques, medals      
[shop=rice]: A shop that exclusively or mainly sells various varieties of rice grains (uncooked rice).      
[shop=motorcycle_parts]: A place selling motorcycle parts, accessories, motor oil, chemicals, etc.      
[shop=power_tools]: power_tools      
[shop=shopping_centre]: A shopping centre: a collection of shops facing a parking lot      
[shop=shop]: shop      
[shop=household]: household      
[shop=groundskeeping]: A shop selling groundskeeping equipment, equipment service and supplies for groundskeeping      
[shop=wool]: Shop selling wool      
[shop=organic]: organic      
[shop=insurance]: insurance      
[shop=ski]: A shop that sells skis and/or related accessories and services      
[shop=furnace]: furnace      
[shop=hvac]: A shop selling equipment for heating, ventilation & air-conditioning.      
[shop=lamps]: lamps      
[shop=truck]: A dealer that primarily sells trucks (heavy goods vehicles).      
[shop=military_surplus]: Shop selling used military equipment      
[shop=brewing_supplies]: A shop selling ingredients and equipment for home brewing of beer and wine.      
[shop=nuts]: A shop selling raw edible seeds, nuts, dried fruits, pistachios, almonds, hazelnuts etc.      
[shop=garden_furniture]: Shop focused on selling garden furniture (sheds, outdoor tables, gates, fences, ...).      
[shop=office_supplies]: A shop selling office supplies      
[shop=psychic]: A business that offers to predict the future for hire: fortune-telling, tarot, palmistry, tea-leaf reading, etc.      
[shop=marketplace]: marketplace      
[shop=wigs]: Shop focused on selling wigs.      
[shop=wood]: wood      
[shop=general_store]: general_store      
[shop=fishmonger]: fishmonger      
[shop=market]: market      
[shop=souvenir]: Shop selling souvenirs.      
[shop=truck_repair]: A shop that repairs large trucks (HGVs).      
[shop=hookah]: A shop that sells hookahs and/or related accessories      
[shop=golf]: Golf equipment shop      
[shop=salon]: salon      
[shop=discount]: discount      
[shop=construction]: construction      
[shop=winery]: winery      
[shop=plumbing]: plumbing      
[shop=ship_chandler]: shop selling ship-related equipment      
[shop=tableware]: tableware      
[shop=money_transfer]: money_transfer      
[shop=retail]: retail      
[shop=wedding]: wedding      
[shop=bathroom]: bathroom      
[shop=health]: health      
[shop=equestrian]: A shop where you can buy riding equipment for rider, horse and stable.      
[shop=other]: other      
[shop=disused]: disused      
[shop=scooter]: A shop selling scooters. Also see shop=motorcycle, shop=bicycle and shop=mobility_scooter.      
[shop=surf]: A shop selling surf related items.      
[shop=pest_control]: A business selling goods to exterminate rats, insects etc.      
[shop=signs]: signs      
[shop=communication]: communication      
[shop=plumber]: plumber      
[shop=bridal]: bridal      
[shop=glass]: glass      
[shop=windows]: windows      
[shop=shipping]: shipping      
[shop=trailer]: A shop that sells trailers, related accessories and services.      
[shop=medical]: Medical store / medical house      
[shop=stationary]: stationary      
[shop=chandler]: A chandler, or also ship chandler are shops or agents specialized in offering a wide range of services towards ships.      
[shop=fireworks]: fireworks      
[shop=auction]: auction      
[shop=point_of_sale]: point_of_sale      
[shop=builder]: builder      
[shop=hat]: hat      
[shop=mobility]: mobility      
[shop=gold_buyer]: gold_buyer      
[shop=tractor]: A shop that sells tractors and/or related accessories and services.      
[shop=auction_house]: auction_house      
[shop=car_repair;car]: car_repair;car      
[shop=unknown]: unknown      
[shop=empty]: empty      
[shop=piercing]: piercing      
[shop=unattended]: unattended      
[shop=photography]: photography      
[shop=workshop]: workshop      
[shop=watch]: watch      
[shop=spa]: spa      
[shop=print]: print      
[shop=tools]: a shop that sells tools      
[shop=mobile_recharge]: mobile_recharge      
[shop=local shop]: local shop      
[shop=handicraft]: handicraft      
[shop=tanning]: tanning      
[shop=sari-sari]: sari-sari      
[shop=internet]: internet      
[shop=plant_hire]: A shop hiring out heavy equipment.      
[shop=atv]: A shop that sells ATVs (Quads) and related accessories and services      
[shop=saloon]: saloon      
[shop=cleaning]: cleaning      
[shop=battery]: battery      
[shop=charcoal]: charcoal      
[shop=office]: office      
[shop=gold]: gold      
[shop=soap]: soap      
[shop=builders_merchant]: builders_merchant      
[shop=computer_repair]: computer_repair      
[shop=canoe_hire]: A place where you can rent a canoe.      
[shop=catering]: catering      
[shop=decoration]: decoration      
[shop=orthopedics]: orthopedics      
[shop=comics]: comics      
[shop=greengrocer;hardware;bakery;butcher;clothes;shoes;fabric;electronics]: greengrocer;hardware;bakery;butcher;clothes;shoes;fabric;electronics      
[shop=supplements]: supplements      
[shop=clock]: clock      
[shop=sewing_machines]: sewing_machines      
[shop=sunglasses]: sunglasses      
[shop=phone]: phone      
[shop=sign]: sign      
[shop=clothes;shoes]: clothes;shoes      
[shop=pet_food]: pet_food      
[shop=hardware_store]: hardware_store      
[shop=restaurant]: restaurant      
[shop=marine]: marine      
[shop=snack]: A shop which sells snacks.      
[shop=heating]: heating      
[shop=beer]: beer      
[shop=wine_cellar]: wine_cellar      
[shop=dressmaker]: dressmaker      
[shop=printshop]: printshop      
[shop=nail_salon]: nail_salon      
[shop=spare_parts]: spare_parts      
[shop=garage]: garage      
[shop=towing]: towing      
[shop=knife]: knife      
[shop=junk_yard]: Focusing and storage and destruction of old automobiles including selling of after market parts.      
[shop=fast_food]: fast_food      
[shop=hats]: hats      
[shop=carpenter]: carpenter      
[shop=stone]: stone      
[shop=duty_free]: duty_free      
[shop=nails]: nails      
[shop=fixme]: fixme      
[shop=electronics_repair]: electronics_repair      
[shop=folk_art]: folk_art      
[shop=building_supplies]: building_supplies      
[shop=printer]: printer      
[shop=car_service]: Use tag:shop=car_repair instead.      
[shop=kitchenware]: kitchenware      
[shop=skate]: Used for skate shops.      
[shop=outdoor;hunting]: outdoor;hunting      
[shop=number_plate]: number_plate      
[shop=local_shop]: local_shop      
[shop=pool]: pool      
[shop=cake]: cake      
[shop=cafe]: cafe      
[shop=grossery]: grossery      
[shop=clocks]: clocks      
[shop=commerce]: commerce      
[shop=cobbler]: cobbler      
[shop=storage]: storage      
[shop=crafts]: crafts      
[shop=yarn]: yarn      
[shop=upholstery]: upholstery      
[shop=lumber]: lumber      
[shop=closed]: closed      
[shop=firewood]: firewood      
[shop=pawn]: pawn      
[shop=flour]: flour      
[shop=fitness]: fitness      
[shop=coffee_roasting]: coffee_roasting      
[shop=satellite_tv]: satellite_tv      
[shop=warehouse]: warehouse      
[shop=service]: service      
[shop=olive_oil]: olive_oil      
[shop=hairdresser;beauty]: hairdresser;beauty      
[shop=metal]: metal      
[shop=esoteric]: A shop selling esoteric paraphernalia such as crystals, pendants, books, incense, oils, etc...      
[shop=art_supplies]: art_supplies      
[shop=angling]: angling      
[shop=dog_grooming]: dog_grooming      
[shop=agricultural_engines]: agricultural_engines      
[shop=bakery;pastry]: bakery;pastry      
[shop=fruit]: fruit      
[shop=blinds]: blinds      
[shop=floor]: floor      
[shop=stamps]: stamps      
[shop=gambling]: DISCOURAGED, use tag:shop=bookmaker, tag:shop=lottery, tag:amenity=casino, tag:leisure=amusement_arcade, or tag:amenity=gambling instead.      
[shop=consignment]: consignment      
[shop=souvenirs]: souvenirs      
[shop=ironing]: ironing      
[shop=design]: design      
[shop=packaging]: packaging      
[shop=aquarium]: aquarium      
[shop=wallpaper]: wallpaper      
[shop=liquor]: liquor      
[shop=sanitary]: sanitary      
[shop=bicycle_repair]: bicycle_repair      
[shop=mattress]: mattress      
[shop=glasses]: glasses      
[shop=drugstore]: drugstore      
[shop=*]: *      
[shop=guns]: guns      
[shop=cement]: cement      
[shop=store]: store      
[shop=pond]: pond      
[shop=machinery]: machinery      
[shop=soft_drugs]: soft_drugs      
[shop=pet_supplies]: pet_supplies      
[shop=shoes;clothes]: shoes;clothes      
[shop=books;stationery]: books;stationery      
[shop=taxi]: taxi      
[shop=optician;hearing_aids]: optician;hearing_aids      
[shop=eggs]: eggs      
[shop=laundromat]: laundromat      
[shop=drug_paraphernalia]: drug_paraphernalia      
[shop=bbq]: A shop that sells barbeque grills and accessories.      
[shop=gun]: gun      
[shop=business_machines]: Shop which sells or leases equipment such as photocopiers, printers, cash registers etc.      
[shop=new_age]: new_age      
[shop=fruits]: fruits      
[shop=building]: building      
[shop=milk]: milk      
[shop=tourism]: tourism      
[shop=home]: home      
[shop=motorsports]: A shop selling off-road, watercraft, and/or sports vehicles and related accessories      
[shop=interior_design]: interior_design      
[shop=condo]: condo      
[shop=advertising]: advertising      
[shop=cash]: cash      
[shop=safety]: safety      
[shop=ice]: ice      
[shop=oil]: oil      
[shop=mobile_phone;electronics]: mobile_phone;electronics      
[shop=bedding]: bedding      
[shop=boat_repair]: A place where you can get your boat repaired.      
[shop=headshop]: headshop      
[shop=newspaper]: newspaper      
[shop=homeware]: homeware      
[shop=convenience;alcohol]: convenience;alcohol      
[shop=card]: card      
[shop=cards]: cards      
[shop=fence]: fence      
[shop=art_gallery]: art_gallery      
[shop=ceramics]: ceramics      
[shop=beauty_supply]: beauty_supply      
[shop=flowers]: flowers      
[shop=dentures]: A shop specialized in making and fitting dentures      
[shop=retails]: retails      
[shop=electrician]: electrician      
[shop=shisha]: shisha      
[shop=umbrella]: umbrella      
[shop=3d_printing]: A shop printing 3D objects.      
[shop=recycling]: recycling      
[shop=knives]: knives      
[shop=tile]: tile      
[shop=lawn_mower]: lawn_mower      
[shop=bar]: bar      
[shop=industrial]: industrial      
[shop=agricultural_machinery]: agricultural_machinery      
[shop=amusements]: amusements      
[shop=salvage]: salvage      
[shop=street_vendor]: A shop without its own building      
[shop=garden_machinery]: garden_machinery      
[shop=cleaning_products]: cleaning_products      
[shop=vintage]: vintage      
[shop=orthopaedics]: orthopaedics      
[shop=mobility_scooter]: A shop selling mobility scooters.      
[shop=religious]: religious      
[shop=plastic]: plastic      
[shop=welding]: welding      
[shop=shed]: shed      
[shop=outlet]: outlet      
[shop=equipment_rental]: equipment_rental      
[shop=snowmobile]: A shop that sells snowmobiles and/or related accessories and services.      
[shop=electrics]: electrics      
[shop=telephone]: telephone      
[shop=roofing]: roofing      
[shop=weaver]: weaver      
[shop=doors;glaziery]: doors;glaziery      
[shop=coins]: coins      
[shop=Tienda_y_taller_de_articulos_de_greda]: Tienda_y_taller_de_articulos_de_greda      
[shop=stones]: stones      
[shop=barber]: barber      
[shop=letting_agent]: letting_agent      
[shop=mortgage]: mortgage      
[shop=floors]: floors      
[shop=patisserie]: patisserie      
[shop=auto_repair]: auto_repair      
[shop=plants]: plants      
[shop=textiles]: textiles      
[shop=knitting]: knitting      
[shop=costume]: costume      
[shop=drinks]: drinks      
[shop=vulcanizing]: vulcanizing      
[shop=dance]: dance      
[shop=textile]: textile      
[shop=financial]: financial      
[shop=ski_rental]: ski_rental      
[shop=farm_equipment]: farm_equipment      
[shop=flea_market]: flea_market      
[shop=baby]: baby      
[shop=diet]: diet      
[shop=car_repair;tyres]: car_repair;tyres      
[shop=parquet]: parquet      
[shop=batteries]: batteries      
[shop=mobile_home]: A shop for mobile-, or manufactured-homes.      
[shop=keys]: keys      
[shop=beauty;hairdresser]: beauty;hairdresser      
[shop=tourist]: tourist      
[shop=window_construction]: window_construction      
[shop=electric]: electric      
[shop=diary]: diary      
[shop=print_shop]: print_shop      
[shop=balloon]: balloon      
[shop=greengrocer;hardware;bakery;butcher;clothes;shoes;sports;fabric]: greengrocer;hardware;bakery;butcher;clothes;shoes;sports;fabric      
[shop=furnishings]: furnishings      
[shop=motorhome]: Shops that sell motor homes (RVs). Distinct from shop=mobile_home , selling homes that become statically fixed.      
[shop=juice]: juice      
[shop=electrotools]: electrotools      
[shop=cooking_utensils]: cooking_utensils      
[shop=accountant]: accountant      
[shop=lpg]: lpg      
[shop=sweets]: sweets      
[shop=survey]: survey      
[shop=dry_cleaning;tailor]: dry_cleaning;tailor      
[shop=pharmacy]: pharmacy      
[shop=electronic_parts]: electronic_parts      
[shop=convenience;car_repair]: convenience;car_repair      
[shop=solar]: solar      
[shop=collectibles]: collectibles      
[shop=internet_cafe]: internet_cafe      
[shop=paper]: paper      
[shop=stove]: stove      
[shop=printers]: printers      
[shop=fairtrade]: fairtrade      
[shop=nursing_service]: nursing_service      
[shop=rugs]: rugs      
[shop=fire_extinguisher]: fire_extinguisher      
[shop=wellness]: wellness      
[shop=watch_repair]: watch_repair      
[shop=egg]: egg      
[shop=car_accessories]: car_accessories      
[shop=audiologist]: audiologist      
[shop=pet_supply]: pet_supply      
[shop=camping]: camping      
[shop=snacks]: snacks      
[shop=vape]: vape      
[shop=mobile]: mobile      
[shop=phone_repair]: phone_repair      
[shop=diy]: diy      
[shop=beauty;massage]: beauty;massage      
[shop=glassware]: glassware      
[shop=license_plates]: license_plates      
[shop=workwear]: workwear      
[shop=construction_materials]: construction_materials      
[shop=sweet]: sweet      
[shop=Grocery]: Grocery      
[shop=white_goods]: white_goods      
[shop=car_rental]: car_rental      
[shop=generic]: generic      
[shop=lamp]: lamp      
[shop=metal_construction]: metal_construction      
[shop=timber]: timber      
[shop=hometextile]: hometextile      
[shop=financial_services]: financial_services      
[shop=telecom]: telecom      
[shop=hgv]: hgv      
[shop=landscaping]: landscaping      
[shop=embroidery]: embroidery      
[shop=mobile_money_agent]: mobile_money_agent      
[shop=mobile_phone_repair]: mobile_phone_repair      
[shop=optometrist]: optometrist      
[shop=convenience;greengrocer;hardware;furniture;bakery;butcher;clothes;shoes;sports;fabric;electronics]: convenience;greengrocer;hardware;furniture;bakery;butcher;clothes;shoes;sports;fabric;electronics      
[shop=company]: company      
[shop=solicitors]: solicitors      
[shop=ration]: ration      
[shop=clothes_repair]: clothes_repair      
[shop=healthcare]: healthcare      
[shop=gravestone]: gravestone      
[shop=electronics;mobile_phone]: electronics;mobile_phone      
[shop=Saloon]: Saloon      
[shop=animal_feed]: animal_feed      
[shop=horse]: horse      
[shop=fur]: fur      
[shop=kimchi]: kimchi      
[shop=cutlery]: cutlery      
[shop=home_design]: home_design      
[shop=forklift]: forklift      
[shop=dog_hairdresser]: dog_hairdresser      
[shop=weight_loss]: weight_loss      
[shop=minerals]: minerals      
[shop=maps]: A shop selling primarily maps.      
[shop=fancy_dress]: fancy_dress      
[shop=coffee_machines]: coffee_machines      
[shop=car_parts;car_repair]: car_parts;car_repair      
[shop=dive]: dive      
[shop=sauna]: sauna      
[shop=nutrition]: nutrition      
[shop=audio_video]: audio_video      
[shop=pub]: pub      
[shop=wig]: wig      
[shop=van]: van      
[shop=saddlery]: saddlery      
[shop=software]: software      
[shop=water_filter]: water_filter      
[shop=Shop]: Shop      
[shop=vegetables]: vegetables      
[shop=beach]: beach      
[shop=pizza]: pizza      
[shop=alteration]: alteration      
[shop=appliances]: appliances      
[shop=military]: military      
[shop=christmas]: christmas      
[shop=packing]: packing      
[shop=crystal]: crystal      
[shop=machines]: machines      
[shop=free_flying]: Shop focused on selling free flying equipment.      
[shop=chandlery]: chandlery      
[shop=artwork]: artwork      
[shop=interior]: interior      
[shop=electricity]: electricity      
[shop=house]: house      
[shop=hire]: hire      
[shop=dry_food]: dry_food      
[shop=flour_mill]: flour_mill      
[shop=cannery]: cannery      
[shop=grocer]: grocer      
[shop=nursery]: nursery      
[shop=chicken]: chicken      
[shop=coffee;tea]: coffee;tea      
[shop=delicatessen]: delicatessen      
[shop=betting]: betting      
[shop=meat]: meat      
[shop=baking_supplies]: baking_supplies      
[shop=linen]: linen      
[shop=chiropodist]: chiropodist      
[shop=restaurant_supply]: restaurant_supply      
[shop=license_plate]: license_plate      
[shop=footwear]: footwear      
[shop=costume_jewelry]: costume_jewelry      
[shop=foods]: foods      
[shop=photocopies]: photocopies      
[shop=bath]: bath      
[shop=archery]: archery      
[shop=tax]: tax      
[shop=car_bodyshop]: car_bodyshop      
[shop=travel_agent]: travel_agent      
[shop=magic]: magic      
[shop=lawyer]: lawyer      
[shop=shoes_repair]: shoes_repair      
[shop=kitchen;bathroom_furnishing]: kitchen;bathroom_furnishing      
[shop=robot]: A shop that sells robots and/or related accessories and services.      
[shop=beverages;alcohol]: beverages;alcohol      
[shop=crockery]: crockery      
[shop=piano]: piano      
[shop=fabrics]: fabrics      
[shop=florist;pet;garden_centre]: florist;pet;garden_centre      
[shop=cooking]: cooking      
[shop=shoemaker]: shoemaker      
[shop=fair_trade]: fair_trade      
[shop=beekeeper]: beekeeper      
[shop=building_material]: building_material      
[shop=farmers_market]: farmers_market      
[shop=printer_cartridges]: printer_cartridges      
[shop=mobility_aids]: mobility_aids      
[shop=mattresses]: mattresses      
[shop=bubble_tea]: bubble_tea      
[shop=finance]: finance      
[shop=domestic_appliances]: domestic_appliances      
[shop=construction_equipment]: construction_equipment      
[shop=fitted_furniture]: fitted_furniture      
[shop=picture_framing]: picture_framing      
[shop=bicycle;motorcycle]: bicycle;motorcycle      
[shop=gym]: gym      
[shop=apiary]: apiary      
[shop=agriculture]: agriculture      
[shop=chemist;stationery;convenience]: chemist;stationery;convenience      
[shop=baby_care]: baby_care      
[shop=cigarettes]: cigarettes      
[shop=home_improvement]: home_improvement      
[shop=tea;coffee]: tea;coffee      
[shop=pawnshop]: pawnshop      
[shop=tobacconist]: tobacconist      
[shop=records]: records      
[shop=blacksmith]: blacksmith      
[shop=it]: it      
[shop=community]: community      
[shop=cigar]: cigar      
[shop=clothes;toys]: clothes;toys      
[shop=arts_and_crafts]: arts_and_crafts      
[shop=handicrafts]: handicrafts      
[shop=watchmaker]: watchmaker      
[shop=television]: television      
[shop=funeral]: funeral      
[shop=stoves]: stoves      
[shop=clothes;gift]: clothes;gift      
[shop=studio]: studio      
[shop=growshop]: growshop      
[shop=caterer]: caterer      
[shop=air_conditioning]: air_conditioning      
[shop=produce]: produce      
[shop=golf_cart]: A place that primarily sells golf carts      
[shop=painter]: painter      
[shop=cash_for_gold]: cash_for_gold      
[shop=poultry]: poultry      
[shop=machine]: machine      
[shop=garage_door]: garage_door      
[shop=cell_phones]: cell_phones      
[shop=communications]: communications      
[shop=fan_shop]: fan_shop      
[shop=hardware;doityourself]: hardware;doityourself      
[shop=appliance_repair]: appliance_repair      
[shop=minimarket]: minimarket      
[shop=greengrocer;bakery;butcher;clothes;shoes]: greengrocer;bakery;butcher;clothes;shoes      
[shop=bazar]: bazar      
[shop=natural_gas]: natural_gas      
[shop=marijuana]: marijuana      
[shop=alternative_medicine]: alternative_medicine      
[shop=kids]: kids      
[shop=repair_service]: repair_service      
[shop=tailoring]: tailoring      
[shop=misc]: misc      
[shop=bathrooms]: bathrooms      
[shop=luggage]: luggage      
[shop=farm_supplies]: farm_supplies      
[shop=automotive]: automotive      
[shop=livestock]: livestock      
[shop=safety_equipment]: safety_equipment      
[shop=comodities]: comodities      
[shop=greengrocer;hardware;furniture;bakery;butcher;clothes;shoes;sports;fabric;electronics]: greengrocer;hardware;furniture;bakery;butcher;clothes;shoes;sports;fabric;electronics      
[shop=auto]: auto      
[shop=education]: education      
[shop=luxury]: luxury      
[shop=optics]: optics      
[shop=Market]: Market      
[shop=tobacco;newsagent]: tobacco;newsagent      
[shop=popcorn]: popcorn      
[shop=stairs]: A shop where you can purchase different kinds of stairs      
[shop=commercial]: commercial      
[shop=grocery_store]: grocery_store      
[shop=online]: online      
[shop=denture]: denture      
[shop=carpentry]: carpentry      
[shop=yoga]: yoga      
[shop=post_office]: post_office      
[shop=vehicle_inspection]: vehicle_inspection      
[shop=pool_supplies]: pool_supplies      
[shop=newsagent;stationery]: newsagent;stationery      
[shop=clothing_alterations]: clothing_alterations      
[shop=garden_equipment]: garden_equipment      
[shop=window_tinting]: window_tinting      
[shop=junk]: junk      
[shop=philately]: philately      
[shop=shoe_repair;key_cutting]: shoe_repair;key_cutting      
[shop=dessert]: dessert      
[shop=homewares]: homewares      
[shop=smartshop]: smartshop      
[shop=propane]: propane      
[shop=beekeeping]: beekeeping      
[shop=shoes;bag]: shoes;bag      
[shop=household_goods]: household_goods      
[shop=services]: services      
[shop=farm_implement]: farm_implement      
[shop=boat_parts]: A place selling boat parts and accessories.      
[shop=restaurant_supplies]: restaurant_supplies      
[shop=car_audio]: car_audio      
[shop=animal_food]: animal_food      
[shop=flag]: flag      
[shop=hydroponics]: A shop primarily selling hydroponics supplies.      
[shop=solicitor]: solicitor      
[shop=ppe]: ppe      
[shop=rug]: rug      
[shop=fencing]: fencing      
[shop=farm_shop]: farm_shop      
[shop=fitness_equipment]: fitness_equipment      
[shop=farm_supply]: farm_supply      
[shop=fashion_acessories]: fashion_acessories      
[shop=collectables]: collectables      
[shop=delivery]: delivery      
[shop=concrete]: concrete      
[shop=surplus]: surplus      
[shop=outdoors]: outdoors      
[shop=vegetable]: vegetable      
[shop=showroom]: showroom      
[shop=vehicle]: vehicle      
[shop=gemstones]: gemstones      
[shop=laundry;dry_cleaning]: laundry;dry_cleaning      
[shop=variety]: variety      
[shop=stationery;toys]: stationery;toys      
[shop=manicure]: manicure      
[shop=atelier]: atelier      
[shop=plastics]: plastics      
[shop=alcohol;convenience]: alcohol;convenience      
[shop=vaping]: vaping      
[shop=tienda_y_taller_de_articulos_de_greda]: tienda_y_taller_de_articulos_de_greda      
[shop=beauty_products]: beauty_products      
[shop=confectionery;gift]: confectionery;gift      
[shop=medicine]: medicine      
[shop=rock]: rock      
[shop=roof]: roof      
[shop=watches;jewelry]: watches;jewelry      
[shop=e-bike]: e-bike      
[shop=socks]: socks      
[shop=disability]: disability      
[shop=optical]: optical      
[shop=jewelry;watches]: jewelry;watches      
[shop=gallery]: gallery      
[shop=christmas_trees]: christmas_trees      
[shop=bulk]: bulk      
[shop=coal]: coal      
[shop=coffee_machine]: coffee_machine      
[shop=alarm]: alarm      
[shop=hotel]: hotel      
[shop=paints]: paints      
[shop=porcelain]: porcelain      
[shop=pools]: pools      
[shop=map]: map      
[shop=cookware]: cookware      
[shop=dressed_stone]: dressed_stone      
[shop=vinery]: vinery      
[shop=casino]: casino      
[shop=recruitment]: recruitment      
[shop=barbecue]: barbecue      
[shop=tortilleria]: tortilleria      
[shop=small_engine]: small_engine      
[shop=shopping_mall]: shopping_mall      
[shop=library]: library      
[shop=fishing;hunting]: fishing;hunting      
[shop=tailor;dry_cleaning]: tailor;dry_cleaning      
[shop=car key and air conditioner service shops]: car key and air conditioner service shops      
[shop=lubricant]: lubricant      
[shop=tailor; locksmith; copyshop; photo; shoe_repair]: tailor; locksmith; copyshop; photo; shoe_repair      
"
